/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.farmquest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dapi.DAPI;
import org.nandayo.dapi.HexUtil;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.Util;
import org.nandayo.dapi.model.Point;
import org.nandayo.farmquest.bstats.bukkit.Metrics;
import org.nandayo.farmquest.command.MainCommand;
import org.nandayo.farmquest.listener.BukkitListener;
import org.nandayo.farmquest.listener.CustomListener;
import org.nandayo.farmquest.model.Farmer;
import org.nandayo.farmquest.service.BossBarManager;
import org.nandayo.farmquest.service.registry.ConfigRegistry;
import org.nandayo.farmquest.service.registry.FarmRegistry;
import org.nandayo.farmquest.service.registry.QuestRegistry;
import org.nandayo.farmquest.service.registry.ToolRegistry;
import org.nandayo.farmquest.util.LanguageUtil;
import org.nandayo.farmquest.util.UpdateChecker;
import org.nandayo.farmquest.util.Wrapper;

public final class FarmQuest
extends JavaPlugin {
    public final ItemStack FARM_MARKER = ItemCreator.of(Material.GOLDEN_AXE).name("&6Farm Marker").get();
    public final ItemStack FARM_DETECTOR = ItemCreator.of(Material.RABBIT_HIDE).get();
    public final HashMap<Player, Point[]> playerMarkers = new HashMap();
    private static FarmQuest instance;
    public final Random random = new Random();
    public BossBarManager bossBarManager;
    public QuestRegistry questRegistry;
    public FarmRegistry farmRegistry;
    public ToolRegistry toolRegistry;
    public ConfigRegistry configRegistry;
    public Wrapper wrapper;
    public LanguageUtil languageUtil;

    public void onEnable() {
        instance = this;
        Objects.requireNonNull(this.getCommand("farmquest")).setExecutor((CommandExecutor)new MainCommand());
        Bukkit.getPluginManager().registerEvents((Listener)new BukkitListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new CustomListener(), (Plugin)this);
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.setupDAPI();
        this.wrapper = new Wrapper(this);
        this.doRegistry();
        this.bossBarManager = new BossBarManager(this);
        this.bossBarManager.start();
        new Metrics((Plugin)this, 25233);
        new UpdateChecker(this, 124581).inform();
    }

    public void onDisable() {
        this.closeRegistry(false);
        if (this.bossBarManager != null) {
            this.bossBarManager.stop();
        }
        instance = null;
    }

    private void setupDAPI() {
        DAPI dapi = new DAPI((Plugin)this);
        dapi.registerMenuListener();
        Util.PREFIX = "&8[<#008387>FarmQuest&8]&7 ";
        HexUtil.placeholders = new HashMap<String, String>(){
            {
                this.put("{TITLE}", "<#008387>");
                this.put("{STAR}", "<#145f66>");
                this.put("{WHITE}", "<#ecfdff>");
                this.put("{WARN}", "<#e56666>");
                this.put("{SUCCESS}", "<#bfe769>");
            }
        };
        dapi.setMissingArgsMsg("{WARN}Usage: /{command} {current_args} {options}");
    }

    private void doRegistry() {
        this.questRegistry = new QuestRegistry(this);
        this.questRegistry.load();
        this.farmRegistry = new FarmRegistry(this);
        this.farmRegistry.load();
        this.toolRegistry = new ToolRegistry(this);
        this.toolRegistry.load();
        this.configRegistry = new ConfigRegistry(this);
        this.configRegistry.load();
        for (Player player : Bukkit.getOnlinePlayers()) {
            Farmer.load(player.getUniqueId());
        }
        this.languageUtil = new LanguageUtil(this, this.configRegistry.getConfig().getString("lang_file", "en_US"));
    }

    public void closeRegistry(boolean reload) {
        for (Farmer farmer : new ArrayList<Farmer>(Farmer.getPlayers())) {
            farmer.save();
        }
        this.farmRegistry.save();
        this.questRegistry.save();
        if (reload) {
            this.doRegistry();
        }
    }

    public void tell(@NotNull CommandSender receiver, String ... message) {
        for (String m : message) {
            receiver.sendMessage(HexUtil.parse(Util.PREFIX + m));
        }
    }

    public String formatTime(int time) {
        int sec = time;
        int min = sec / 60;
        int hour = min / 60;
        sec %= 60;
        min %= 60;
        StringBuilder sb = new StringBuilder();
        if ((hour %= 24) >= 10) {
            sb.append(hour);
        } else {
            sb.append(0).append(hour);
        }
        sb.append(":");
        if (min >= 10) {
            sb.append(min);
        } else {
            sb.append(0).append(min);
        }
        sb.append(":");
        if (sec >= 10) {
            sb.append(sec);
        } else {
            sb.append(0).append(sec);
        }
        return sb.toString().trim();
    }

    @Nullable
    public ItemStack buildItem(ConfigurationSection section) {
        if (section == null) {
            return null;
        }
        Material mat = Material.getMaterial((String)section.getString("material", ""));
        if (mat == null) {
            return null;
        }
        String displayName = section.getString("display_name", "");
        List lore = section.getStringList("lore");
        boolean unbreakable = section.getBoolean("unbreakable", false);
        ItemCreator creator = ItemCreator.of(mat).name(displayName).lore(lore).unbreakable(unbreakable);
        for (String ecm : section.getStringList("enchantments")) {
            Enchantment enchantment;
            String[] split = ecm.split(",");
            if (split.length != 2 || (enchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)split[0].toLowerCase(Locale.ENGLISH)))) == null) continue;
            int level = Integer.parseInt(split[1]);
            creator.enchant(enchantment, level);
        }
        List flags = section.getStringList("flags");
        if (flags.contains("ALL")) {
            creator.hideFlag(ItemFlag.values());
        } else {
            for (String flag : flags) {
                try {
                    creator.hideFlag(ItemFlag.valueOf((String)flag));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        return creator.get();
    }

    @Generated
    public static FarmQuest getInstance() {
        return instance;
    }
}

