/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dapi.guimanager;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.nandayo.dapi.DAPI;
import org.nandayo.dapi.HexUtil;
import org.nandayo.dapi.guimanager.Button;
import org.nandayo.dapi.guimanager.LazyButton;

public class Menu {
    private final List<Button> buttons = new ArrayList<Button>();
    private final List<LazyButton> lazyButtons = new ArrayList<LazyButton>();
    private int size = 27;
    private String title = "Default";
    private Inventory inventory = null;
    private Consumer<Inventory> closeCallback = inventory -> {};
    private boolean emptySlotsModifiable = false;

    public final boolean isButton(int slot) {
        return this.buttons.stream().anyMatch(b -> b.getSlot() == slot);
    }

    public final Button getButton(int slot) {
        return this.buttons.stream().filter(b -> b.getSlot() == slot).findFirst().orElse(null);
    }

    public final boolean isLazyButton(int slot) {
        return this.lazyButtons.stream().anyMatch(lb -> lb.getSlots().contains(slot));
    }

    public final LazyButton getLazyButton(int slot) {
        return this.lazyButtons.stream().filter(lb -> lb.getSlots().contains(slot)).findFirst().orElse(null);
    }

    public final void handleCloseCallback() {
        if (this.closeCallback != null) {
            this.closeCallback.accept(this.inventory);
        }
    }

    protected final void createInventory(int size, String title) {
        this.inventory = Bukkit.createInventory(null, (int)size, (String)HexUtil.parse(title));
    }

    protected final void createInventory(int size) {
        this.createInventory(size, this.title);
    }

    protected final void createInventory() {
        this.createInventory(this.size, this.title);
    }

    protected final void setSize(int size) {
        this.size = size;
        this.createInventory(size, this.title);
    }

    protected final void setTitle(String title) {
        this.title = title;
        this.createInventory(this.size, title);
    }

    protected final void addButton(Button button) {
        this.buttons.add(button);
    }

    protected final void addLazyButton(LazyButton lazyButton) {
        this.lazyButtons.add(lazyButton);
    }

    protected final ItemStack getInvItem(int slot) {
        if (this.inventory == null) {
            return null;
        }
        return this.inventory.getItem(slot);
    }

    protected final void setInvItem(int slot, ItemStack item) {
        if (this.inventory == null) {
            return;
        }
        this.inventory.setItem(slot, item);
    }

    protected final void makeEmptySlotsModifiable(boolean b) {
        this.emptySlotsModifiable = b;
    }

    protected final void runOnClose(Consumer<Inventory> callBack) {
        this.closeCallback = callBack;
    }

    protected final void displayTo(Player p) {
        if (this.inventory == null) {
            this.createInventory(this.size, this.title);
        }
        Inventory inv = this.inventory;
        for (Button button : this.buttons) {
            inv.setItem(button.getSlot(), button.getItem());
        }
        for (LazyButton lazyButton : this.lazyButtons) {
            for (int slot : lazyButton.getSlots()) {
                inv.setItem(slot, lazyButton.getItem());
            }
        }
        p.openInventory(inv);
        DAPI dapi = DAPI.getInstance();
        p.setMetadata(dapi.GUI_METADATA_KEY, (MetadataValue)new FixedMetadataValue(dapi.plugin, (Object)this));
    }

    @Generated
    protected List<Button> getButtons() {
        return this.buttons;
    }

    @Generated
    protected List<LazyButton> getLazyButtons() {
        return this.lazyButtons;
    }

    @Generated
    protected Inventory getInventory() {
        return this.inventory;
    }

    @Generated
    protected boolean isEmptySlotsModifiable() {
        return this.emptySlotsModifiable;
    }
}

