/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dapi;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.HexUtil;

public class ItemCreator {
    private final ItemStack itemStack;
    private final ItemMeta meta;

    public ItemCreator(@NotNull ItemStack itemStack) {
        this.itemStack = itemStack.clone();
        this.meta = this.itemStack.getItemMeta();
    }

    public static ItemCreator of(@NotNull ItemStack itemStack) {
        return new ItemCreator(itemStack);
    }

    public static ItemCreator of(@NotNull Material material) {
        return new ItemCreator(new ItemStack(material));
    }

    public ItemStack get() {
        if (this.meta != null) {
            this.itemStack.setItemMeta(this.meta);
        }
        return this.itemStack;
    }

    public ItemCreator amount(int amount) {
        if (this.itemStack != null) {
            this.itemStack.setAmount(amount);
        }
        return this;
    }

    public ItemCreator name(@NotNull String name) {
        if (this.meta != null) {
            this.meta.setDisplayName(HexUtil.parse(name));
        }
        return this;
    }

    public ItemCreator name(@NotNull Supplier<String> nameSupplier) {
        return this.name(nameSupplier.get());
    }

    public ItemCreator lore(String ... lore) {
        if (this.meta != null) {
            ArrayList<String> loreFix = new ArrayList<String>();
            for (String line : lore) {
                loreFix.add(HexUtil.parse(line));
            }
            this.meta.setLore(loreFix);
        }
        return this;
    }

    public ItemCreator lore(@NotNull List<String> lore) {
        return this.lore(lore.toArray(new String[0]));
    }

    public ItemCreator lore(@NotNull Supplier<List<String>> loreSupplier) {
        return this.lore(loreSupplier.get().toArray(new String[0]));
    }

    public ItemCreator addLore(String ... lore) {
        if (this.meta != null) {
            ArrayList<String> loreFix = this.meta.getLore() == null ? new ArrayList<String>() : new ArrayList(this.meta.getLore());
            for (String line : lore) {
                loreFix.add(HexUtil.parse(line));
            }
            this.meta.setLore(loreFix);
        }
        return this;
    }

    public ItemCreator addLore(@NotNull List<String> lore) {
        return this.addLore(lore.toArray(new String[0]));
    }

    public ItemCreator addLore(@NotNull Supplier<List<String>> loreSupplier) {
        return this.addLore(loreSupplier.get().toArray(new String[0]));
    }

    public ItemCreator enchant(@NotNull Enchantment enchantment, int level) {
        if (this.meta != null) {
            this.meta.addEnchant(enchantment, level, true);
        }
        return this;
    }

    public ItemCreator hideFlag(ItemFlag ... flags) {
        if (this.meta != null) {
            this.meta.addItemFlags(flags);
        }
        return this;
    }

    public ItemCreator unbreakable(boolean unbreakable) {
        if (this.meta != null) {
            this.meta.setUnbreakable(unbreakable);
        }
        return this;
    }
}

