/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.user;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.shaded.dapi.util.Util;
import org.nandayo.dmentions.user.MentionUser;

public class UserManager {
    private static final Map<UUID, MentionUser> USERS = new HashMap<UUID, MentionUser>();

    public static UserManager getInstance() {
        return DMentions.inst().getUserManager();
    }

    public UserManager() {
    }

    @ApiStatus.Internal
    public void register(MentionUser user) {
        Preconditions.checkNotNull((Object)user, (Object)"User cannot be null.");
        USERS.put(user.getUuid(), user);
    }

    @ApiStatus.Internal
    public void unregister(UUID uuid) {
        Preconditions.checkNotNull((Object)uuid, (Object)"User uuid cannot be null.");
        USERS.remove(uuid);
    }

    @NotNull
    public Collection<MentionUser> getUsers() {
        return Collections.unmodifiableCollection(USERS.values());
    }

    @Nullable
    public MentionUser getUser(UUID uuid) {
        return USERS.get(uuid);
    }

    @NotNull
    public MentionUser loadUser(UUID uuid) {
        YamlConfiguration config;
        ConfigurationSection section;
        Preconditions.checkNotNull((Object)uuid, (Object)"User uuid cannot be null.");
        File file = new File(DMentions.inst().getDataFolder(), "players/" + String.valueOf(uuid) + ".yml");
        if (!file.exists()) {
            file.getParentFile().mkdirs();
        }
        if ((section = (config = YamlConfiguration.loadConfiguration((File)file)).getConfigurationSection("==")) == null) {
            return new MentionUser(uuid, true, null);
        }
        return MentionUser.deserialize(section.getValues(true));
    }

    @ApiStatus.Internal
    public void saveToFile(MentionUser user) {
        Preconditions.checkNotNull((Object)user, (Object)"User cannot be null.");
        File file = new File(DMentions.inst().getDataFolder(), "players/" + String.valueOf(user.getUuid()) + ".yml");
        if (!file.exists()) {
            file.getParentFile().mkdirs();
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        config.set("==", user.serialize());
        try {
            config.save(file);
        }
        catch (IOException e) {
            Util.log(String.format("Failed to save player file for '%s'.", user.getUuid()));
        }
    }

    @ApiStatus.Internal
    public void saveAllToFile() {
        for (MentionUser user : USERS.values()) {
            this.saveToFile(user);
        }
    }

    @Deprecated(since="1.8.4")
    public UserManager(DMentions ignore) {
    }

    @Deprecated(since="1.8.4", forRemoval=true)
    public void saveChanges() {
    }

    @Deprecated(since="1.8.4", forRemoval=true)
    public boolean getMentionMode(Player player) {
        MentionUser user = this.getUser(player.getUniqueId());
        return user != null && user.isMentionMode();
    }

    @Deprecated(since="1.8.4", forRemoval=true)
    public void setMentionMode(Player player, boolean mode) {
        MentionUser user = this.getUser(player.getUniqueId());
        if (user == null) {
            return;
        }
        user.setMentionMode(mode);
    }

    @Deprecated(since="1.8.4", forRemoval=true)
    public String getMentionDisplay(Player player) {
        MentionUser user = this.getUser(player.getUniqueId());
        return user == null ? player.getDisplayName() : user.getDisplayName();
    }

    @Deprecated(since="1.8.4", forRemoval=true)
    public void setMentionDisplay(Player player, String display) {
        MentionUser user = this.getUser(player.getUniqueId());
        if (user == null) {
            return;
        }
        user.setCustomizedDisplayName(display);
    }
}

