/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.user;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.shaded.dapi.util.Util;

public class SingleFolderMigrator {
    public static void migrate() {
        File oldPlayersFile = new File(DMentions.inst().getDataFolder(), "players.yml");
        if (!oldPlayersFile.exists()) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)oldPlayersFile);
        if (config.getBoolean("migrated")) {
            return;
        }
        ConfigurationSection playersSection = config.getConfigurationSection("players");
        if (playersSection != null) {
            for (String id : playersSection.getKeys(false)) {
                UUID uuid = UUID.fromString(id);
                boolean mentions = playersSection.getBoolean(id + ".mentions");
                String mentionDisplay = playersSection.getString(id + ".mention_display");
                File newFile = new File(DMentions.inst().getDataFolder(), "players/" + String.valueOf(uuid) + ".yml");
                YamlConfiguration newConfig = YamlConfiguration.loadConfiguration((File)newFile);
                String ns = "==.";
                newConfig.set(ns + "uuid", (Object)uuid.toString());
                newConfig.set(ns + "mention_mode", (Object)mentions);
                newConfig.set(ns + "customized_display_name", (Object)mentionDisplay);
                try {
                    newConfig.save(newFile);
                }
                catch (IOException e) {
                    Util.log("Failed to save new player folder for '" + String.valueOf(uuid) + "'. " + String.valueOf(e));
                }
            }
        }
        try {
            if (!oldPlayersFile.delete()) {
                throw new IOException();
            }
        }
        catch (IOException e) {
            Util.log("Failed to delete old players file. " + String.valueOf(e));
            try {
                config.set("migrated", (Object)true);
                config.save(oldPlayersFile);
            }
            catch (IOException ee) {
                Util.log("Failed to mark old players file migrated. " + String.valueOf(ee));
            }
        }
    }
}

