/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.user;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MentionUser
implements ConfigurationSerializable {
    @NotNull
    private final UUID uuid;
    private boolean mentionMode;
    @Nullable
    private String customizedDisplayName;

    @ApiStatus.Internal
    public MentionUser(UUID uuid, boolean mentionMode, String customizedDisplayName) {
        Preconditions.checkNotNull((Object)uuid);
        this.uuid = uuid;
        this.mentionMode = mentionMode;
        this.customizedDisplayName = customizedDisplayName;
    }

    @NotNull
    public String getDisplayName() {
        if (this.customizedDisplayName != null) {
            return this.customizedDisplayName;
        }
        OfflinePlayer offlinePlayer = this.getOfflinePlayer();
        return offlinePlayer.getName() != null ? offlinePlayer.getName() : "UNKNOWN";
    }

    public Optional<Player> getPlayer() {
        return Optional.ofNullable(Bukkit.getPlayer((UUID)this.uuid));
    }

    @NotNull
    public OfflinePlayer getOfflinePlayer() {
        return Bukkit.getOfflinePlayer((UUID)this.uuid);
    }

    @Nullable
    public String getName() {
        return this.getOfflinePlayer().getName();
    }

    @ApiStatus.Internal
    @NotNull
    public Map<String, Object> serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("uuid", this.uuid.toString());
        map.put("mention_mode", this.mentionMode);
        map.put("customized_display_name", this.customizedDisplayName);
        return map;
    }

    @ApiStatus.Internal
    @NotNull
    public static MentionUser deserialize(Map<String, Object> map) {
        UUID uuid = UUID.fromString((String)map.get("uuid"));
        boolean mentionMode = (Boolean)map.getOrDefault("mention_mode", true);
        String customizedDisplayName = map.getOrDefault("customized_display_name", null);
        return new MentionUser(uuid, mentionMode, customizedDisplayName);
    }

    @NotNull
    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public boolean isMentionMode() {
        return this.mentionMode;
    }

    @Nullable
    @Generated
    public String getCustomizedDisplayName() {
        return this.customizedDisplayName;
    }

    @Generated
    public void setMentionMode(boolean mentionMode) {
        this.mentionMode = mentionMode;
    }

    @Generated
    public void setCustomizedDisplayName(@Nullable String customizedDisplayName) {
        this.customizedDisplayName = customizedDisplayName;
    }
}

