/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.user;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dmentions.user.ModuleData;

@ApiStatus.Experimental
abstract class AbstractModuleDataHolder {
    @NotNull
    private final Map<String, ModuleData> moduleDataMap = new HashMap<String, ModuleData>();

    @NotNull
    public Set<String> getModuleDataIds() {
        return Collections.unmodifiableSet(this.moduleDataMap.keySet());
    }

    public ModuleData getModuleData(String moduleId) {
        return this.moduleDataMap.get(moduleId);
    }

    public <T extends ModuleData> T getModuleData(String moduleId, Class<T> dataClass) {
        ModuleData data = this.moduleDataMap.get(moduleId);
        if (dataClass.isInstance(data)) {
            return (T)((ModuleData)dataClass.cast(data));
        }
        return null;
    }

    public void setModuleData(String moduleId, ModuleData data) {
        this.moduleDataMap.put(moduleId, data);
    }

    public boolean hasModuleData(String moduleId) {
        return this.moduleDataMap.containsKey(moduleId);
    }

    public void removeModuleData(String moduleId) {
        this.moduleDataMap.remove(moduleId);
    }

    @NotNull
    public <T extends ModuleData> T getOrCreateModuleData(String moduleId, Class<T> dataClass, Supplier<T> factory) {
        T existing = this.getModuleData(moduleId, dataClass);
        if (existing != null) {
            return existing;
        }
        ModuleData newData = (ModuleData)factory.get();
        this.setModuleData(moduleId, newData);
        return (T)newData;
    }
}

