/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.shaded.dapi.util;

import java.util.regex.Pattern;

public class VersionUtil {
    private static final int VERSION_BASE = 100;

    public static int intify(String version, String separator, int targetPartCount) {
        String cleanVersion = version.split("-")[0];
        String[] parts = cleanVersion.split(Pattern.quote(separator));
        int v = 0;
        int multiplier = 1;
        for (int i = parts.length - 1; i >= 0; --i) {
            try {
                int num = Integer.parseInt(parts[i]);
                v += num * multiplier;
                multiplier *= 100;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (targetPartCount > parts.length) {
            int paddingFactor = targetPartCount - parts.length;
            v *= (int)Math.pow(100.0, paddingFactor);
        }
        return v;
    }

    public static int intify(String version, String separator) {
        return VersionUtil.intify(version, separator, version.split(Pattern.quote(separator)).length);
    }

    public static int intify(String version, int targetPartCount) {
        return VersionUtil.intify(version, ".", targetPartCount);
    }

    public static int intify(String version) {
        return VersionUtil.intify(version, ".");
    }

    public static String stringify(int version, String separator, int targetPartCount) {
        int i;
        if (version == 0) {
            StringBuilder sb = new StringBuilder("0");
            for (int i2 = 1; i2 < targetPartCount; ++i2) {
                sb.append(separator).append("0");
            }
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        int tempVersion = Math.abs(version);
        int numParts = (int)(Math.log10(tempVersion) / Math.log10(100.0)) + 1;
        for (i = numParts - 1; i >= 0; --i) {
            int divisor = (int)Math.pow(100.0, i);
            int part = tempVersion / divisor;
            sb.append(part);
            tempVersion %= divisor;
            if (i <= 0) continue;
            sb.append(separator);
        }
        if (targetPartCount > numParts) {
            for (i = numParts; i < targetPartCount; ++i) {
                sb.append(separator).append("0");
            }
        }
        return sb.toString();
    }

    public static String stringify(int version, String separator) {
        if (version == 0) {
            return "0";
        }
        return VersionUtil.stringify(version, separator, (int)(Math.log10(Math.abs(version)) / Math.log10(100.0)) + 1);
    }

    public static String stringify(int version, int targetPartCount) {
        return VersionUtil.stringify(version, ".", targetPartCount);
    }

    public static String stringify(int version) {
        return VersionUtil.stringify(version, ".");
    }
}

