/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.shaded.dapi.service;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public abstract class YAMLRegistry {
    @NotNull
    private final JavaPlugin plugin;
    private File file;
    @NotNull
    private static final List<YAMLRegistry> REGISTRIES = new ArrayList<YAMLRegistry>();

    protected YAMLRegistry(@NotNull JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadFile();
        REGISTRIES.add(this);
    }

    @NotNull
    protected abstract String filePath();

    protected void loadFile() {
        String path = this.filePath();
        File file = new File(this.plugin.getDataFolder(), path);
        if (!file.exists()) {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            this.saveDefaultResource();
        }
        this.file = file;
    }

    private InputStream getDefaultResource() {
        return this.plugin.getResource(this.filePath());
    }

    private void saveDefaultResource() {
        if (this.getDefaultResource() != null) {
            this.plugin.saveResource(this.filePath(), false);
        }
    }

    @NotNull
    protected FileConfiguration getConfiguration() {
        return YamlConfiguration.loadConfiguration((File)this.file);
    }

    public abstract boolean isLoaded();

    public abstract void setLoaded(boolean var1);

    public abstract void onLoad();

    public abstract void onUnload();

    public static List<YAMLRegistry> getRegistries() {
        return Collections.unmodifiableList(REGISTRIES);
    }

    public static void loadRegistries() {
        for (YAMLRegistry registry : REGISTRIES) {
            registry.onLoad();
        }
    }

    public static void unloadRegistries() {
        for (YAMLRegistry registry : REGISTRIES) {
            if (!registry.isLoaded()) continue;
            registry.onUnload();
        }
    }

    @NotNull
    @Generated
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    @Generated
    public File getFile() {
        return this.file;
    }
}

