/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.shaded.dapi.service;

import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public class Platform {
    private static Type type;

    @NotNull
    public static Type getType() {
        if (type != null) {
            return type;
        }
        String serverName = Bukkit.getServer().getName();
        switch (serverName.toLowerCase()) {
            case "leaf": {
                type = Type.LEAF;
                return type;
            }
            case "paper": {
                type = Type.PAPER;
                return type;
            }
            case "purpur": {
                type = Type.PURPUR;
                return type;
            }
            case "pufferfish": {
                type = Type.PUFFERFISH;
                return type;
            }
            case "craftbukkit": {
                type = Type.SPIGOT;
                return type;
            }
        }
        type = Type.OTHER;
        return type;
    }

    public static boolean isLeaf() {
        return Platform.getType() == Type.LEAF;
    }

    public static boolean isPaper() {
        return Platform.getType() == Type.PAPER;
    }

    public static boolean isPurpur() {
        return Platform.getType() == Type.PURPUR;
    }

    public static boolean isPufferfish() {
        return Platform.getType() == Type.PUFFERFISH;
    }

    public static boolean isSpigot() {
        return Platform.getType() == Type.SPIGOT;
    }

    public static boolean isPaperFork() {
        if (Platform.isPaper() || Platform.isPurpur() || Platform.isPufferfish() || Platform.isLeaf()) {
            return true;
        }
        if (Platform.isSpigot()) {
            return false;
        }
        try {
            Class.forName("com.destroystokyo.paper.PaperConfig");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    public static enum Type {
        LEAF,
        PAPER,
        PUFFERFISH,
        PURPUR,
        SPIGOT,
        OTHER;

    }
}

