/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.shaded.dapi.model;

import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dmentions.shaded.dapi.model.Point;

public class BoundingBox {
    private Point minPoint;
    private Point maxPoint;
    private String worldName;

    public BoundingBox(@NotNull Point point1, @NotNull Point point2, @NotNull String worldName) {
        this.minPoint = Point.getMinimum(point1, point2);
        this.maxPoint = Point.getMaximum(point1, point2);
        this.worldName = worldName;
    }

    public void resize(@NotNull Point point1, @NotNull Point point2, @NotNull String worldName) {
        this.minPoint = Point.getMinimum(point1, point2);
        this.maxPoint = Point.getMaximum(point1, point2);
        this.worldName = worldName;
    }

    @Nullable
    public World getWorld() {
        return Bukkit.getWorld((String)this.worldName);
    }

    @Nullable
    public Location getMinimumLocation() {
        if (this.getWorld() == null) {
            return null;
        }
        return this.minPoint.toLocation(this.getWorld());
    }

    @Nullable
    public Location getMaximumLocation() {
        if (this.getWorld() == null) {
            return null;
        }
        return this.maxPoint.toLocation(this.getWorld());
    }

    public boolean isInside(@NotNull Point point) {
        return point.getX() >= this.minPoint.getX() && point.getX() <= this.maxPoint.getX() && point.getY() >= this.minPoint.getY() && point.getY() <= this.maxPoint.getY() && point.getZ() >= this.minPoint.getZ() && point.getZ() <= this.maxPoint.getZ();
    }

    public boolean isInside(@NotNull Location location) {
        return this.isInside(new Point(location));
    }

    public String parseString() {
        return this.worldName + ",[" + this.getMinPoint().getX() + "_" + this.getMinPoint().getY() + "_" + this.getMinPoint().getZ() + "],[" + this.getMaxPoint().getX() + "_" + this.getMaxPoint().getY() + "_" + this.getMaxPoint().getZ() + "]";
    }

    @NotNull
    public static BoundingBox fromString(@NotNull String str) {
        String[] split = str.split(",");
        String worldName = split[0];
        String[] point1split = split[1].replace("[", "").replace("]", "").split("_");
        Point minPoint = new Point(Integer.parseInt(point1split[0]), Integer.parseInt(point1split[1]), Integer.parseInt(point1split[2]));
        String[] point2split = split[2].replace("[", "").replace("]", "").split("_");
        Point maxPoint = new Point(Integer.parseInt(point2split[0]), Integer.parseInt(point2split[1]), Integer.parseInt(point2split[2]));
        return new BoundingBox(minPoint, maxPoint, worldName);
    }

    @Generated
    public Point getMinPoint() {
        return this.minPoint;
    }

    @Generated
    public Point getMaxPoint() {
        return this.maxPoint;
    }

    @Generated
    public String getWorldName() {
        return this.worldName;
    }
}

