/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.shaded.dapi.message;

import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dmentions.shaded.dapi.DAPI;
import org.nandayo.dmentions.shaded.dapi.message.ChannelBossBarMessage;
import org.nandayo.dmentions.shaded.dapi.message.ChannelMessage;
import org.nandayo.dmentions.shaded.dapi.message.ChannelTitleMessage;
import org.nandayo.dmentions.shaded.dapi.util.ColorizeType;
import org.nandayo.dmentions.shaded.dapi.util.Util;

public abstract class ChannelType {
    public static final ChannelType CHAT = new ChannelType(){

        @Override
        public void send(@NotNull CommandSender receiver, @NotNull ChannelMessage message) {
            receiver.sendMessage(message.colorize(ColorizeType.LEGACY).getRawMessage());
        }
    };
    public static final ChannelType ACTION_BAR = new ChannelType(){

        @Override
        public void send(@NotNull CommandSender receiver, @NotNull ChannelMessage message) {
            if (!(receiver instanceof Player)) {
                return;
            }
            Player player = (Player)receiver;
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message.colorize(ColorizeType.LEGACY).getRawMessage()));
        }
    };
    public static final ChannelType TITLE = new ChannelType(){

        @Override
        public void send(@NotNull CommandSender receiver, @NotNull ChannelMessage message) {
            if (!(receiver instanceof Player)) {
                return;
            }
            Player player = (Player)receiver;
            ChannelTitleMessage titleMessage = message instanceof ChannelTitleMessage ? (ChannelTitleMessage)message : ChannelTitleMessage.fromParent(message, true);
            player.sendTitle(titleMessage.getRawMessage(), "", titleMessage.getFadeInTicks(), titleMessage.getStayTicks(), titleMessage.getFadeOutTicks());
        }
    };
    public static final ChannelType SUBTITLE = new ChannelType(){

        @Override
        public void send(@NotNull CommandSender receiver, @NotNull ChannelMessage message) {
            if (!(receiver instanceof Player)) {
                return;
            }
            Player player = (Player)receiver;
            ChannelTitleMessage titleMessage = (message instanceof ChannelTitleMessage ? (ChannelTitleMessage)message : ChannelTitleMessage.fromParent(message, false)).colorize(ColorizeType.LEGACY);
            player.sendTitle("", titleMessage.getRawSecondaryMessage(), titleMessage.getFadeInTicks(), titleMessage.getStayTicks(), titleMessage.getFadeOutTicks());
        }
    };
    public static final ChannelType TITLE_AND_SUBTITLE = new ChannelType(){

        @Override
        public void send(@NotNull CommandSender receiver, @NotNull ChannelMessage message) {
            if (!(receiver instanceof Player)) {
                return;
            }
            Player player = (Player)receiver;
            ChannelTitleMessage titleMessage = (message instanceof ChannelTitleMessage ? (ChannelTitleMessage)message : ChannelTitleMessage.fromParent(message, true)).colorize(ColorizeType.LEGACY);
            player.sendTitle(titleMessage.getRawMessage(), titleMessage.getRawSecondaryMessage(), titleMessage.getFadeInTicks(), titleMessage.getStayTicks(), titleMessage.getFadeOutTicks());
        }
    };
    public static final ChannelType BOSS_BAR = new ChannelType(){

        @Override
        public void send(@NotNull CommandSender receiver, @NotNull ChannelMessage message) {
            if (!(receiver instanceof Player)) {
                return;
            }
            Player player = (Player)receiver;
            ChannelBossBarMessage bossBarMessage = (message instanceof ChannelBossBarMessage ? (ChannelBossBarMessage)message : ChannelBossBarMessage.fromParent(message)).colorize(ColorizeType.LEGACY);
            NamespacedKey key = new NamespacedKey("dapi", "boss_bar_" + Util.generateRandomLowerCaseString(8));
            KeyedBossBar bb = Bukkit.createBossBar((NamespacedKey)key, (String)bossBarMessage.getRawMessage(), (BarColor)bossBarMessage.getColor(), (BarStyle)bossBarMessage.getStyle(), (BarFlag[])bossBarMessage.getFlags());
            bb.addPlayer(player);
            Bukkit.getScheduler().runTaskLater(DAPI.getPlugin(), () -> {
                bb.removePlayer(player);
                Bukkit.removeBossBar((NamespacedKey)key);
            }, (long)bossBarMessage.getStayTicks());
        }
    };

    private ChannelType() {
    }

    public abstract void send(@NotNull CommandSender var1, @NotNull ChannelMessage var2);

    public final void send(@NotNull CommandSender receiver, @NotNull String message) {
        this.send(receiver, new ChannelMessage(message));
    }

    public final void sendWithPrefix(@NotNull CommandSender receiver, @NotNull ChannelMessage message) {
        this.send(receiver, message.insertPrefix());
    }

    public final void sendWithPrefix(@NotNull CommandSender receiver, @NotNull String message) {
        this.sendWithPrefix(receiver, new ChannelMessage(message));
    }

    public final void sendAll(@NotNull ChannelMessage message, boolean includeConsole) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.send((CommandSender)player, message);
        }
        if (includeConsole) {
            this.send((CommandSender)Bukkit.getConsoleSender(), message);
        }
    }

    public final void sendAll(@NotNull String message, boolean includeConsole) {
        this.sendAll(new ChannelMessage(message), includeConsole);
    }

    public final void sendAllWithPrefix(@NotNull ChannelMessage message, boolean includeConsole) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.sendWithPrefix((CommandSender)player, message);
        }
        if (includeConsole) {
            this.sendWithPrefix((CommandSender)Bukkit.getConsoleSender(), message);
        }
    }

    public final void sendAllWithPrefix(@NotNull String message, boolean includeConsole) {
        this.sendAllWithPrefix(new ChannelMessage(message), includeConsole);
    }
}

