/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.shaded.dapi.message;

import java.awt.Component;
import lombok.Generated;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dmentions.shaded.dapi.message.ChannelMessage;
import org.nandayo.dmentions.shaded.dapi.model.MiniString;
import org.nandayo.dmentions.shaded.dapi.util.ColorizeType;
import org.nandayo.dmentions.shaded.dapi.util.Util;
import org.nandayo.dmentions.shaded.dapi.util.Validate;

public class ChannelBossBarMessage
extends ChannelMessage {
    private int stayTicks = 60;
    @NotNull
    private BarColor color = BarColor.BLUE;
    @NotNull
    private BarStyle style = BarStyle.SOLID;
    @NotNull
    private BarFlag[] flags = new BarFlag[0];
    private double progress = 1.0;

    protected ChannelBossBarMessage(MiniString message, int stayTicks, double progress, BarColor color, BarStyle style, BarFlag ... flags) {
        super(message);
    }

    public ChannelBossBarMessage(String message, int stayTicks, double progress, BarColor color, BarStyle style, BarFlag ... flags) {
        super(message);
        Validate.validate(color != null, "BarColor cannot be null!");
        Validate.validate(style != null, "BarStyle cannot be null!");
        Validate.validate(flags != null, "BarFlag cannot be null!");
        this.stayTicks = Math.max(1, stayTicks);
        this.progress = Math.max(0.0, Math.min(1.0, progress));
        this.color = color;
        this.style = style;
        this.flags = flags;
    }

    @Deprecated(since="1.4.0")
    public ChannelBossBarMessage(Component message, int stayTicks, double progress, BarColor color, BarStyle style, BarFlag ... flags) {
        super("");
        Validate.validate(color != null, "BarColor cannot be null!");
        Validate.validate(style != null, "BarStyle cannot be null!");
        Validate.validate(flags != null, "BarFlag cannot be null!");
        this.stayTicks = Math.max(1, stayTicks);
        this.progress = Math.max(0.0, Math.min(1.0, progress));
        this.color = color;
        this.style = style;
        this.flags = flags;
    }

    public ChannelBossBarMessage(String message, int stayTicks, double progress) {
        super(message);
        this.stayTicks = Math.max(1, stayTicks);
        this.progress = Math.max(0.0, Math.min(1.0, progress));
    }

    @Deprecated(since="1.4.0")
    public ChannelBossBarMessage(Component message, int stayTicks, double progress) {
        super("");
        this.stayTicks = Math.max(1, stayTicks);
        this.progress = Math.max(0.0, Math.min(1.0, progress));
    }

    protected ChannelBossBarMessage(MiniString message) {
        super(message);
    }

    public ChannelBossBarMessage(String message) {
        super(message);
    }

    @Deprecated(since="1.4.0")
    public ChannelBossBarMessage(Component message) {
        super("");
    }

    public static ChannelBossBarMessage fromParent(ChannelMessage message) {
        return new ChannelBossBarMessage(message.message);
    }

    @Override
    public ChannelBossBarMessage copy() {
        return new ChannelBossBarMessage(this.message, this.stayTicks, this.progress, this.color, this.style, this.flags);
    }

    public ChannelBossBarMessage progress(double progress) {
        return new ChannelBossBarMessage(this.message, this.stayTicks, progress, this.color, this.style, this.flags);
    }

    @Override
    public ChannelBossBarMessage insertPrefix() {
        return new ChannelBossBarMessage(Util.PREFIX + this.message.getRawText(), this.stayTicks, this.progress, this.color, this.style, this.flags);
    }

    @Override
    public ChannelBossBarMessage colorize(ColorizeType colorizeType) {
        return new ChannelBossBarMessage(this.message.colorize(colorizeType), this.stayTicks, this.progress, this.color, this.style, this.flags);
    }

    @Override
    public ChannelBossBarMessage replace(String key, String value) {
        return new ChannelBossBarMessage(this.message.replace(key, value), this.stayTicks, this.progress, this.color, this.style, this.flags);
    }

    @Generated
    public int getStayTicks() {
        return this.stayTicks;
    }

    @NotNull
    @Generated
    public BarColor getColor() {
        return this.color;
    }

    @NotNull
    @Generated
    public BarStyle getStyle() {
        return this.style;
    }

    @NotNull
    @Generated
    public BarFlag[] getFlags() {
        return this.flags;
    }

    @Generated
    public double getProgress() {
        return this.progress;
    }
}

