/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.shaded.dapi.guimanager.menu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dmentions.shaded.dapi.DAPI;
import org.nandayo.dmentions.shaded.dapi.guimanager.button.AbstractButton;
import org.nandayo.dmentions.shaded.dapi.guimanager.button.SingleSlotButton;

public abstract class AbstractMenu {
    @NotNull
    private final List<AbstractButton> abstractButtons = new ArrayList<AbstractButton>();
    @Nullable
    private Inventory inventory;

    protected List<AbstractButton> getButtons() {
        return Collections.unmodifiableList(this.abstractButtons);
    }

    public boolean isButton(int slot) {
        return this.getButton(slot) != null;
    }

    @Nullable
    public AbstractButton getButton(int slot) {
        return this.abstractButtons.stream().filter(b -> b.matchesSlot(slot)).findFirst().orElse(null);
    }

    protected void addButton(@NotNull AbstractButton button) {
        for (Integer slot : button.updatedMutableSlots()) {
            this.removeButton(slot);
        }
        this.abstractButtons.add(button);
    }

    protected void removeButton(@NotNull AbstractButton button) {
        this.abstractButtons.remove(button);
    }

    @Nullable
    protected AbstractButton removeButton(int slot) {
        AbstractButton abstractButton = this.getButton(slot);
        if (abstractButton != null) {
            abstractButton.removeSlot(slot);
        }
        return abstractButton;
    }

    @Nullable
    public Inventory getInventory() {
        return this.inventory;
    }

    protected void setInventory(@NotNull Inventory inventory) {
        this.inventory = inventory;
    }

    @Nullable
    protected ItemStack getInvItem(int slot) {
        if (this.getInventory() == null) {
            return null;
        }
        return this.getInventory().getItem(slot);
    }

    protected void setInvItem(int slot, @Nullable ItemStack item) {
        if (this.getInventory() == null) {
            return;
        }
        this.getInventory().setItem(slot, item);
    }

    protected void displayTo(@NotNull Player player) {
        if (this.inventory == null) {
            return;
        }
        this.uploadBackgroundButtons();
        this.uploadButtons();
        player.openInventory(this.inventory);
        player.setMetadata(DAPI.GUI_METADATA_KEY, (MetadataValue)new FixedMetadataValue(DAPI.getPlugin(), (Object)this));
    }

    protected void uploadBackgroundButtons() {
        if (this.inventory == null) {
            return;
        }
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            SingleSlotButton singleSlotButton = this.backgroundButtonFunction().apply(i);
            if (singleSlotButton == null || this.getButton(i) != null) continue;
            this.addButton(singleSlotButton);
        }
    }

    protected void uploadButtons() {
        if (this.inventory == null) {
            return;
        }
        for (AbstractButton abstractButton : this.getButtons()) {
            for (int slot : abstractButton.updatedMutableSlots()) {
                this.inventory.setItem(slot, abstractButton.getItem());
            }
        }
    }

    public boolean isEmptySlotsModifiable() {
        return false;
    }

    public Function<Integer, @Nullable SingleSlotButton> backgroundButtonFunction() {
        return slot -> null;
    }

    public <T extends Inventory> Consumer<T> onClose() {
        return inventory -> {};
    }

    public BiConsumer<PlayerInventory, Integer> onPlayerInventoryClick() {
        return (playerInventory, slot) -> {};
    }
}

