/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.shaded.dapi.guimanager;

import java.util.List;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class MenuItem {
    @Nullable
    private final Material material;
    @NotNull
    private final String name;
    @NotNull
    private final List<String> lore;
    @NotNull
    private final List<String> extraLore;
    @NotNull
    private final List<String> commands;

    public MenuItem(@Nullable Material material, @NotNull String name, @NotNull List<String> lore, @NotNull List<String> extraLore, @NotNull List<String> commands) {
        this.material = material;
        this.name = name;
        this.lore = lore;
        this.extraLore = extraLore;
        this.commands = commands;
    }

    @NotNull
    public static <T extends ConfigurationSection> MenuItem read(@NotNull T section) {
        Material material = Material.getMaterial((String)section.getString("material", ""));
        String name = section.getString("name", "");
        List lore = section.getStringList("lore");
        List extraLore = section.getStringList("extraLore");
        List commands = section.getStringList("commands");
        return new MenuItem(material, name, lore, extraLore, commands);
    }

    @Nullable
    @Generated
    public Material getMaterial() {
        return this.material;
    }

    @NotNull
    @Generated
    public String getName() {
        return this.name;
    }

    @NotNull
    @Generated
    public List<String> getLore() {
        return this.lore;
    }

    @NotNull
    @Generated
    public List<String> getExtraLore() {
        return this.extraLore;
    }

    @NotNull
    @Generated
    public List<String> getCommands() {
        return this.commands;
    }
}

