/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.shaded.dapi.formula;

import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dmentions.shaded.dapi.formula.ConditionalValueFormulaImpl;
import org.nandayo.dmentions.shaded.dapi.formula.ExpressionModifier;
import org.nandayo.dmentions.shaded.dapi.formula.Factory;
import org.nandayo.dmentions.shaded.dapi.formula.FactoryImpl;
import org.nandayo.dmentions.shaded.dapi.formula.SimpleValueFormulaImpl;
import org.nandayo.dmentions.shaded.dapi.formula.TableValueFormulaImpl;
import org.nandayo.dmentions.shaded.dapi.formula.ValueFormula;
import org.nandayo.dmentions.shaded.dapi.util.DAPIException;
import org.nandayo.dmentions.shaded.dapi.util.Validate;

abstract class ValueFormulaImpl
implements ValueFormula {
    public static final Factory FACTORY = FactoryImpl.createFactory();

    ValueFormulaImpl() {
    }

    @NotNull
    public static ValueFormula create(Map<String, Object> map) {
        Validate.notNull(map, "Map cannot be null.");
        ValueFormula.Type type = ValueFormulaImpl.getType((String)map.get("type"));
        switch (type) {
            case SIMPLE: {
                return SimpleValueFormulaImpl.deserialize(map);
            }
            case CONDITIONAL: {
                return ConditionalValueFormulaImpl.deserialize(map);
            }
            case TABLE: {
                return TableValueFormulaImpl.deserialize(map);
            }
        }
        throw new DAPIException("Invalid formula type.");
    }

    @NotNull
    public static ValueFormula.Type getType(String type) {
        try {
            return ValueFormula.Type.valueOf(type.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            return ValueFormula.Type.SIMPLE;
        }
    }

    static abstract class ExpressionModifierImpl
    implements ExpressionModifier {
        ExpressionModifierImpl() {
        }
    }
}

