/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.shaded.dapi.formula;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dmentions.shaded.dapi.formula.ExpressionModifier;
import org.nandayo.dmentions.shaded.dapi.formula.ValueFormula;
import org.nandayo.dmentions.shaded.dapi.formula.ValueFormulaImpl;
import org.nandayo.dmentions.shaded.dapi.shaded.objecthunter.exp4j.Expression;
import org.nandayo.dmentions.shaded.dapi.shaded.objecthunter.exp4j.ExpressionBuilder;
import org.nandayo.dmentions.shaded.dapi.util.Validate;

class SimpleValueFormulaImpl
extends ValueFormulaImpl {
    @NotNull
    private final ValueFormula.Type type = ValueFormula.Type.SIMPLE;
    @NotNull
    private final String formula;
    @NotNull
    private final Set<String> variables;
    @NotNull
    private final Expression expression;

    private SimpleValueFormulaImpl(String formula, Set<String> variables) {
        Validate.notNull(formula, "Formula cannot be null.");
        Validate.notNull(variables, "Variables cannot be null.");
        this.formula = formula;
        this.variables = new HashSet<String>(variables);
        this.expression = new ExpressionBuilder(formula).variables(variables).build();
    }

    @Override
    @NotNull
    public ExpressionModifier setVariable(String variable, double value) {
        return new SimpleExpressionModifierImpl(this.expression).setVariable(variable, value);
    }

    @Override
    public double evaluate() {
        return new SimpleExpressionModifierImpl(this.expression).evaluate();
    }

    @NotNull
    public Map<String, Object> serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", (Object)this.type);
        map.put("formula", this.formula);
        map.put("variables", this.variables);
        return map;
    }

    public static SimpleValueFormulaImpl deserialize(Map<String, Object> map) {
        Validate.notNull(map, "Map cannot be null.");
        String formula = (String)map.get("formula");
        HashSet<String> variables = new HashSet<String>((Collection)map.get("variables"));
        return SimpleValueFormulaImpl.of(formula, variables);
    }

    @NotNull
    public static SimpleValueFormulaImpl of(String formula, Set<String> variables) {
        return new SimpleValueFormulaImpl(formula, variables);
    }

    private static class SimpleExpressionModifierImpl
    extends ValueFormulaImpl.ExpressionModifierImpl {
        @NotNull
        private final Expression clone;

        public SimpleExpressionModifierImpl(Expression existing) {
            Validate.notNull(existing, "Expression cannot be null.");
            this.clone = new Expression(existing);
        }

        @Override
        @NotNull
        public ExpressionModifier setVariable(String variable, double value) {
            this.clone.setVariable(variable, value);
            return this;
        }

        @Override
        public double evaluate() {
            return this.clone.evaluate();
        }
    }
}

