/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.shaded.dapi.formula;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dmentions.shaded.dapi.formula.ComparisonExpressionBuilder;
import org.nandayo.dmentions.shaded.dapi.shaded.objecthunter.exp4j.Expression;
import org.nandayo.dmentions.shaded.dapi.shaded.objecthunter.exp4j.ExpressionBuilder;
import org.nandayo.dmentions.shaded.dapi.util.Validate;

public interface Conditional
extends ConfigurationSerializable {
    @NotNull
    public Expression condition();

    @NotNull
    public Expression formula();

    @NotNull
    public Map<String, Object> serialize();

    @NotNull
    public static Conditional of(final String conditionExpression, final String formulaExpression, Set<String> variables) {
        Validate.notNull(conditionExpression, "Condition expression cannot be null.");
        Validate.notNull(formulaExpression, "Formula expression cannot be null.");
        final Expression condition = new ComparisonExpressionBuilder(conditionExpression).variables(variables).build();
        final Expression formula = new ExpressionBuilder(formulaExpression).variables(variables).build();
        return new Conditional(){

            @Override
            @NotNull
            public Expression condition() {
                return condition;
            }

            @Override
            @NotNull
            public Expression formula() {
                return formula;
            }

            @Override
            @NotNull
            public Map<String, Object> serialize() {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("condition", conditionExpression);
                map.put("formula", formulaExpression);
                return map;
            }
        };
    }

    @NotNull
    public static Conditional deserialize(Map<String, Object> map, Set<String> variables) {
        Validate.notNull(map, "Conditional map cannot be null.");
        String conditionExpression = (String)map.get("condition");
        String formulaExpression = (String)map.get("formula");
        return Conditional.of(conditionExpression, formulaExpression, variables);
    }
}

