/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.shaded.dapi.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dmentions.shaded.dapi.command.CommandHelper;
import org.nandayo.dmentions.shaded.dapi.command.DCommand;

@ApiStatus.Experimental
public interface DSubCommand
extends CommandExecutor,
TabCompleter {
    @NotNull
    public String name();

    @NotNull
    public Set<String> aliases();

    @NotNull
    default public String permission() {
        return "";
    }

    @NotNull
    public DCommand command();

    @NotNull
    public Set<DSubCommand> subCommands();

    public void execute(@NotNull CommandSender var1, @NotNull String[] var2);

    default public void executeIf(@NotNull CommandSender commandSender, @NotNull String[] args, boolean condition) {
        if (!condition) {
            return;
        }
        this.execute(commandSender, args);
    }

    default public void executeCheckPermission(@NotNull CommandSender commandSender, @NotNull String[] args) {
        this.executeIf(commandSender, args, commandSender.hasPermission(this.permission()));
    }

    @Nullable
    default public List<String> tabComplete(@NotNull CommandSender commandSender, @NotNull String[] args) {
        int argNum = args.length;
        ArrayList<String> cumulativeSubCommandNames = new ArrayList<String>();
        for (DSubCommand subCommand : CommandHelper.cumulativeSubCommands(this.command(), 0, argNum)) {
            cumulativeSubCommandNames.add(subCommand.name());
            if (this.ignoreAliasesOnTabComplete()) continue;
            cumulativeSubCommandNames.addAll(subCommand.aliases());
        }
        return cumulativeSubCommandNames;
    }

    default public boolean ignoreAliasesOnTabComplete() {
        return false;
    }

    default public void callSubCommand(@NotNull CommandSender commandSender, @NotNull String[] args, @NotNull String subCommandNameOrAlias) {
        this.subCommand(subCommandNameOrAlias).ifPresent(sc -> sc.executeCheckPermission(commandSender, args));
    }

    @NotNull
    default public Optional<DSubCommand> subCommand(@NotNull String nameOrAlias) {
        return this.subCommands().stream().filter(s -> s.name().equalsIgnoreCase(nameOrAlias) || s.aliases().contains(nameOrAlias)).findFirst();
    }

    default public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        this.execute(commandSender, args);
        return true;
    }

    @Nullable
    default public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        return this.tabComplete(commandSender, args);
    }
}

