/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.shaded.dapi.adventure;

import java.lang.reflect.Field;
import java.util.List;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dmentions.shaded.dapi.adventure.ItemMetaHandler;
import org.nandayo.dmentions.shaded.dapi.shaded.kyori.adventure.platform.bukkit.MinecraftComponentSerializer;
import org.nandayo.dmentions.shaded.dapi.shaded.kyori.adventure.text.Component;
import org.nandayo.dmentions.shaded.dapi.shaded.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.nandayo.dmentions.shaded.dapi.util.DAPIException;
import org.nandayo.dmentions.shaded.dapi.util.Wrapper;

@ApiStatus.Experimental
final class SpigotItemMetaHandler
implements ItemMetaHandler {
    public static final SpigotItemMetaHandler INSTANCE = new SpigotItemMetaHandler();
    private static final Field FIELD_DISPLAYNAME;
    private static final Field FIELD_LORE;

    private SpigotItemMetaHandler() {
    }

    @Override
    public void name(ItemMeta meta, Component component) {
        try {
            FIELD_DISPLAYNAME.set(meta, this.serializeComponent(component));
        }
        catch (IllegalAccessException e) {
            throw new DAPIException("Failed to set item display name.");
        }
    }

    @Override
    public void lore(ItemMeta meta, List<Component> componentList) {
        try {
            FIELD_LORE.set(meta, this.deserializeComponent(componentList));
        }
        catch (IllegalAccessException e) {
            throw new DAPIException("Failed to set item lore.");
        }
    }

    @NotNull
    private Object serializeComponent(Component component) {
        if (Wrapper.getMinecraftVersion() >= 2005) {
            return GsonComponentSerializer.gson().serialize(component);
        }
        return MinecraftComponentSerializer.get().serialize(component);
    }

    @NotNull
    private Component deserializeComponent(Object obj) {
        if (Wrapper.getMinecraftVersion() >= 2005) {
            return GsonComponentSerializer.gson().deserialize((String)obj);
        }
        return MinecraftComponentSerializer.get().deserialize(obj);
    }

    static {
        try {
            Class<?> craftMetaItem = Class.forName("org.bukkit.craftbukkit.inventory.CraftMetaItem");
            FIELD_DISPLAYNAME = craftMetaItem.getDeclaredField("displayName");
            FIELD_DISPLAYNAME.setAccessible(true);
            FIELD_LORE = craftMetaItem.getDeclaredField("lore");
            FIELD_LORE.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            throw new DAPIException("Failed to read CraftMetaItem class and fields!");
        }
    }
}

