/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.shaded.dapi.adventure;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dmentions.shaded.dapi.adventure.GsonHelper;
import org.nandayo.dmentions.shaded.dapi.util.Validate;

class Node {
    private Node parent;
    private String key;
    private Integer index;
    @NotNull
    private JsonElement element;

    public Node(Node parent, String key, Integer index, JsonElement element) {
        Validate.notNull(element, "Element cannot be null!");
        this.parent = parent;
        this.key = key;
        this.index = index;
        this.element = element;
    }

    public void changeKey(String newKey, boolean override) {
        if (this.parent == null || this.key == null) {
            return;
        }
        JsonElement parentElement = this.parent.getElement();
        if (!parentElement.isJsonObject()) {
            return;
        }
        JsonObject obj = parentElement.getAsJsonObject();
        if (!override && obj.has(newKey)) {
            return;
        }
        JsonElement copy = GsonHelper.deepCopy(this.element);
        obj.add(newKey, copy);
        obj.remove(this.key);
        this.key = newKey;
        this.element = copy;
    }

    public void changeKey(String newKey) {
        this.changeKey(newKey, false);
    }

    public void changeIndex(int newIndex, boolean override) {
        if (this.parent == null || this.index == -1) {
            return;
        }
        JsonElement parentElement = this.parent.getElement();
        if (!parentElement.isJsonArray()) {
            return;
        }
        JsonArray array = parentElement.getAsJsonArray();
        if (newIndex >= array.size()) {
            return;
        }
        JsonElement copy = GsonHelper.deepCopy(this.element);
        if (override) {
            array.set(newIndex, copy);
            array.remove(this.index.intValue());
        } else {
            JsonElement other = array.get(newIndex);
            array.set(newIndex, copy);
            array.set(this.index.intValue(), other);
        }
        this.index = newIndex;
        this.element = copy;
    }

    public void changeIndex(int newIndex) {
        this.changeIndex(newIndex, false);
    }

    public void moveToObject(Node newParent) {
        if (this.parent == null) {
            return;
        }
        JsonElement newParentElement = newParent.element;
        if (!newParentElement.isJsonObject()) {
            return;
        }
        JsonObject obj = newParentElement.getAsJsonObject();
        JsonElement copy = GsonHelper.deepCopy(this.element);
        this.destroy();
        obj.add(this.key, copy);
        this.parent = newParent;
        this.element = copy;
    }

    public void moveToArray(Node newParent) {
        JsonElement newParentElement = newParent.element;
        if (!newParentElement.isJsonArray()) {
            return;
        }
        JsonArray array = newParentElement.getAsJsonArray();
        JsonElement copy = GsonHelper.deepCopy(this.element);
        array.add(copy);
    }

    public void move(Node newParent) {
        if (newParent == null) {
            return;
        }
        if (newParent.parent.element.isJsonObject()) {
            this.moveToObject(newParent);
        } else if (newParent.parent.element.isJsonArray()) {
            this.moveToArray(newParent);
        }
    }

    public void destroy() {
        if (this.parent == null) {
            return;
        }
        JsonElement parentElement = this.parent.getElement();
        if (parentElement.isJsonObject()) {
            parentElement.getAsJsonObject().remove(this.key);
        } else if (parentElement.isJsonArray()) {
            parentElement.getAsJsonArray().remove(this.index.intValue());
        }
    }

    @Nullable
    public Node makeSibling(String key, JsonElement delegate) {
        if (this.parent == null) {
            return null;
        }
        JsonElement parentElement = this.parent.getElement();
        JsonElement sibling = GsonHelper.deepCopy(delegate);
        if (parentElement.isJsonObject()) {
            parentElement.getAsJsonObject().add(key, sibling);
            return new Node(this.parent, key, null, sibling);
        }
        if (parentElement.isJsonArray()) {
            JsonArray array = parentElement.getAsJsonArray();
            array.add(sibling);
            return new Node(this.parent, null, array.size() - 1, sibling);
        }
        return null;
    }

    @Nullable
    public Node makeChild(String key, JsonElement delegate) {
        JsonElement child = GsonHelper.deepCopy(delegate);
        if (this.element.isJsonObject()) {
            this.element.getAsJsonObject().add(key, child);
            return new Node(this, key, null, child);
        }
        if (this.element.isJsonArray()) {
            JsonArray array = this.element.getAsJsonArray();
            array.add(child);
            return new Node(this, null, array.size() - 1, child);
        }
        return null;
    }

    @NotNull
    public List<Node> getSiblingsOr(Collection<Node> def) {
        if (this.parent == null) {
            return new ArrayList<Node>(def);
        }
        JsonElement parentElement = this.parent.getElement();
        if (parentElement.isJsonObject()) {
            ArrayList<Node> siblings = new ArrayList<Node>();
            for (Map.Entry entry : parentElement.getAsJsonObject().entrySet()) {
                siblings.add(new Node(this.parent, (String)entry.getKey(), null, (JsonElement)entry.getValue()));
            }
            return siblings;
        }
        if (parentElement.isJsonArray()) {
            JsonArray arr = this.parent.element.getAsJsonArray();
            ArrayList<Node> siblings = new ArrayList<Node>();
            for (int i = 0; i < arr.size(); ++i) {
                siblings.add(new Node(this.parent, null, i, arr.get(i)));
            }
            return siblings;
        }
        return new ArrayList<Node>(def);
    }

    @Nullable
    public List<Node> getSiblings() {
        if (this.parent == null) {
            return null;
        }
        JsonElement parentElement = this.parent.getElement();
        if (parentElement.isJsonObject()) {
            ArrayList<Node> siblings = new ArrayList<Node>();
            for (Map.Entry entry : parentElement.getAsJsonObject().entrySet()) {
                siblings.add(new Node(this.parent, (String)entry.getKey(), null, (JsonElement)entry.getValue()));
            }
            return siblings;
        }
        if (parentElement.isJsonArray()) {
            JsonArray arr = this.parent.element.getAsJsonArray();
            ArrayList<Node> siblings = new ArrayList<Node>();
            for (int i = 0; i < arr.size(); ++i) {
                siblings.add(new Node(this.parent, null, i, arr.get(i)));
            }
            return siblings;
        }
        return null;
    }

    @NotNull
    public List<Node> getChildrenOr(Collection<Node> def) {
        if (this.element.isJsonObject()) {
            ArrayList<Node> children = new ArrayList<Node>();
            for (Map.Entry entry : this.element.getAsJsonObject().entrySet()) {
                children.add(new Node(this, (String)entry.getKey(), null, (JsonElement)entry.getValue()));
            }
            return children;
        }
        if (this.element.isJsonArray()) {
            JsonArray arr = this.element.getAsJsonArray();
            ArrayList<Node> children = new ArrayList<Node>();
            for (int i = 0; i < arr.size(); ++i) {
                children.add(new Node(this, null, i, arr.get(i)));
            }
            return children;
        }
        return new ArrayList<Node>(def);
    }

    @Nullable
    public List<Node> getChildren() {
        if (this.element.isJsonObject()) {
            ArrayList<Node> children = new ArrayList<Node>();
            for (Map.Entry entry : this.element.getAsJsonObject().entrySet()) {
                children.add(new Node(this, (String)entry.getKey(), null, (JsonElement)entry.getValue()));
            }
            return children;
        }
        if (this.element.isJsonArray()) {
            JsonArray arr = this.element.getAsJsonArray();
            ArrayList<Node> children = new ArrayList<Node>();
            for (int i = 0; i < arr.size(); ++i) {
                children.add(new Node(this, null, i, arr.get(i)));
            }
            return children;
        }
        return null;
    }

    public String toString() {
        String p;
        String string = this.parent == null ? "root" : (this.parent.key != null ? this.parent.key : (p = this.parent.index != null ? "[" + this.parent.index + "]" : null));
        if (this.key == null) {
            return String.format("Node[ parent: %s, index: %s]", p, this.index);
        }
        return String.format("Node[ parent: %s, key: %s]", p, this.key);
    }

    @Generated
    public Node getParent() {
        return this.parent;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public Integer getIndex() {
        return this.index;
    }

    @NotNull
    @Generated
    public JsonElement getElement() {
        return this.element;
    }
}

