/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.shaded.dapi.adventure;

import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dmentions.shaded.dapi.adventure.ConstantInfoImpl;
import org.nandayo.dmentions.shaded.dapi.adventure.Depends;
import org.nandayo.dmentions.shaded.dapi.adventure.KeyChange;
import org.nandayo.dmentions.shaded.dapi.adventure.KeyRemoval;
import org.nandayo.dmentions.shaded.dapi.adventure.Node;

interface ConstantInfo
extends Comparable<ConstantInfo> {
    @NotNull
    public String sinceVersion();

    @NotNull
    public String key();

    @Nullable
    public ConstantInfo parent();

    @Nullable
    public KeyChange keyChange();

    @Nullable
    public KeyRemoval keyRemoval();

    @Nullable
    public Depends depends();

    @Nullable
    public <T, R> Function<T, R> valueFunction();

    public boolean matches(Node var1);

    @Override
    default public int compareTo(@NotNull ConstantInfo o) {
        return this.sinceVersion().compareTo(o.sinceVersion());
    }

    public static ConstantInfo imitate(ConstantInfo parent, String key) {
        return new ConstantInfoImpl.Builder().parent(parent).key(key).build();
    }

    public static List<ConstantInfo> find(Node node, List<ConstantInfo> constants) {
        return constants.stream().filter(constant -> constant.matches(node)).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
    }
}

