/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.shaded.dapi.adventure;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.ApiStatus;
import org.nandayo.dmentions.shaded.dapi.adventure.ConstantInfo;
import org.nandayo.dmentions.shaded.dapi.adventure.ConstantInfoImpl;
import org.nandayo.dmentions.shaded.dapi.adventure.Depends;
import org.nandayo.dmentions.shaded.dapi.adventure.GsonHelper;
import org.nandayo.dmentions.shaded.dapi.adventure.KeyChange;
import org.nandayo.dmentions.shaded.dapi.adventure.KeyRemoval;
import org.nandayo.dmentions.shaded.dapi.adventure.Node;
import org.nandayo.dmentions.shaded.dapi.util.Util;
import org.nandayo.dmentions.shaded.dapi.util.Validate;

@ApiStatus.Experimental
public class ComponentTreeConstantsAdapter {
    private static final boolean DEBUG = true;
    private static final ConstantInfo CLICK_EVENT = new ConstantInfoImpl.Builder().sinceVersion("4.21.0").key("click_event").keyChange("clickEvent", "click_event").build();
    private static final ConstantInfo CLICK_EVENT_URL = new ConstantInfoImpl.Builder().sinceVersion("4.21.0").parent(CLICK_EVENT).key("url").keyChange("value", "url").build();
    private static final ConstantInfo CLICK_EVENT_PATH = new ConstantInfoImpl.Builder().sinceVersion("4.21.0").parent(CLICK_EVENT).key("path").keyChange("value", "path").build();
    private static final ConstantInfo CLICK_EVENT_COMMAND = new ConstantInfoImpl.Builder().sinceVersion("4.21.0").parent(CLICK_EVENT).key("command").keyChange("value", "command").build();
    private static final ConstantInfo CLICK_EVENT_PAGE = new ConstantInfoImpl.Builder().sinceVersion("4.21.0").parent(CLICK_EVENT).key("page").keyChange("value", "page").build();
    private static final ConstantInfo HOVER_EVENT = new ConstantInfoImpl.Builder().sinceVersion("4.21.0").key("hover_event").keyChange("hoverEvent", "hover_event").build();
    private static final ConstantInfo SHOW_ENTITY_ID = new ConstantInfoImpl.Builder().sinceVersion("4.21.0").parent(HOVER_EVENT).key("id").keyChange("type", "id").build();
    private static final ConstantInfo SHOW_ENTITY_TYPE = new ConstantInfoImpl.Builder().sinceVersion("4.21.0").parent(HOVER_EVENT).keyRemoval("type", false, Set.of()).build();
    private static final ConstantInfo SHOW_ENTITY_UUID = new ConstantInfoImpl.Builder().sinceVersion("4.21.0").parent(HOVER_EVENT).key("uuid").keyChange("id", "uuid").depends(() -> Set.of(SHOW_ENTITY_ID)).build();
    private static final ConstantInfo HOVER_EVENT_CONTENTS = new ConstantInfoImpl.Builder().sinceVersion("4.21.0").parent(HOVER_EVENT).keyRemoval("contents", true, Set.of(SHOW_ENTITY_ID, SHOW_ENTITY_TYPE)).depends(() -> Set.of(SHOW_ENTITY_ID, SHOW_ENTITY_TYPE)).build();
    private static final ConstantInfo SHOW_ENTITY_ID_VALUE = new ConstantInfoImpl.Builder().sinceVersion("4.15.0").parent(HOVER_EVENT_CONTENTS).key("id").valueFunction(ComponentTreeConstantsAdapter::convertUUID).build();
    private static final List<ConstantInfo> UNSTABLE_CONSTANT_INFO_LIST = List.of(CLICK_EVENT, CLICK_EVENT_URL, CLICK_EVENT_PATH, CLICK_EVENT_COMMAND, CLICK_EVENT_PAGE, HOVER_EVENT, HOVER_EVENT_CONTENTS, SHOW_ENTITY_ID, SHOW_ENTITY_TYPE, SHOW_ENTITY_UUID, SHOW_ENTITY_ID_VALUE);
    private final String receivedJson;
    private final int componentVersion;
    private final int aimingVersion;
    private final boolean backwards;

    private static void debug(String msg) {
        System.err.println(msg);
    }

    public ComponentTreeConstantsAdapter(String receivedJson, String componentVersion, String aimingVersion) {
        Validate.notNull(receivedJson, "Received json string cannot be null.");
        Validate.notNull(componentVersion, "Component version cannot be null.");
        this.receivedJson = receivedJson;
        this.componentVersion = Util.parseVersion(componentVersion);
        this.aimingVersion = Util.parseVersion(aimingVersion);
        this.backwards = this.aimingVersion < this.componentVersion;
    }

    public String doTheJob() {
        if (!this.backwards) {
            return this.receivedJson;
        }
        JsonElement json = GsonHelper.parseJson(this.receivedJson);
        if (!json.isJsonObject()) {
            return this.receivedJson;
        }
        JsonObject rootObject = json.getAsJsonObject();
        List<ConstantInfo> relatedInfos = this.getRelatedConstantInfos();
        ComponentTreeConstantsAdapter.debug("Related infos: " + String.valueOf(relatedInfos));
        this.traverseJson(new Node(null, null, null, (JsonElement)rootObject), relatedInfos);
        return rootObject.toString();
    }

    private void traverseJson(Node current, List<ConstantInfo> relatedConstants) {
        JsonElement curr = current.getElement();
        if (curr.isJsonObject()) {
            JsonObject obj = curr.getAsJsonObject();
            Runnable parentRunnable = null;
            HashSet<ConstantInfo> loadedConstants = new HashSet<ConstantInfo>();
            ArrayDeque<Node> deque = new ArrayDeque<Node>(current.getChildrenOr(new ArrayList<Node>()));
            block0: while (!deque.isEmpty()) {
                Node child = (Node)deque.pop();
                ComponentTreeConstantsAdapter.debug("[1] Searching constant for child " + String.valueOf(child));
                this.traverseJson(child, relatedConstants);
                JsonElement childElementCopy = GsonHelper.deepCopy(child.getElement());
                List<ConstantInfo> constants = ConstantInfo.find(child, relatedConstants);
                for (ConstantInfo constant : constants) {
                    ConstantInfo parentConstant;
                    KeyChange keyChange;
                    ComponentTreeConstantsAdapter.debug("  [2] Found constant for the child. " + String.valueOf(constant));
                    if (loadedConstants.contains(constant)) {
                        ComponentTreeConstantsAdapter.debug("  [2.1] This constant is already loaded, skipping...");
                        continue block0;
                    }
                    Depends depends = constant.depends();
                    if (depends != null) {
                        ComponentTreeConstantsAdapter.debug("  [2.2] A dependant constant.");
                        Set<ConstantInfo> dependants = depends.dependantsWithin(relatedConstants);
                        if (!loadedConstants.containsAll(dependants)) {
                            ComponentTreeConstantsAdapter.debug("    [3] Dependant constants wasn't loaded, sending the child to last of the line.");
                            deque.addLast(child);
                            continue block0;
                        }
                        ComponentTreeConstantsAdapter.debug("    [3] It doesn't have a dependent constant or it's already loaded.");
                    }
                    if ((keyChange = constant.keyChange()) != null) {
                        ComponentTreeConstantsAdapter.debug("  [2.3] Key change found, changing to '" + keyChange.deprecatedKey() + "'");
                        child.changeKey(keyChange.deprecatedKey(), true);
                    }
                    if (parentRunnable == null && (parentConstant = this.findParentConstant(constant, relatedConstants)) != null && !loadedConstants.contains(parentConstant)) {
                        ComponentTreeConstantsAdapter.debug("  [2.4] A parent constant found. " + String.valueOf(parentConstant));
                        parentRunnable = () -> {
                            KeyRemoval keyRemoval = parentConstant.keyRemoval();
                            if (keyRemoval != null && keyRemoval.moveIn()) {
                                ComponentTreeConstantsAdapter.debug("    [3] Moving in children of parent constant.");
                                String parentDeprecatedKey = keyRemoval.deprecatedKey();
                                Node newParent = current.makeChild(keyRemoval.deprecatedKey(), (JsonElement)new JsonObject());
                                if (newParent == null) {
                                    ComponentTreeConstantsAdapter.debug("      [4] Failed to make new parent, skipping");
                                } else {
                                    this.moveInObject(current, newParent, keyRemoval);
                                }
                            } else {
                                child.destroy();
                                ComponentTreeConstantsAdapter.debug("    [3] Move in is disabled, destroying.");
                            }
                        };
                        loadedConstants.add(parentConstant);
                    }
                    loadedConstants.add(constant);
                }
            }
            if (parentRunnable != null) {
                ComponentTreeConstantsAdapter.debug("    [3] Running parent constant runnable.");
                parentRunnable.run();
            }
        } else if (curr.isJsonArray()) {
            JsonArray arr = curr.getAsJsonArray();
            for (int i = 0; i < arr.size(); ++i) {
                JsonElement childElement = arr.get(i);
                this.traverseJson(new Node(current, null, i, childElement), relatedConstants);
            }
        }
    }

    private void traverseJsonCollect(Node current, List<ConstantInfo> relatedConstants, Map<Node, List<ConstantInfo>> map) {
        block4: {
            JsonElement curr;
            block3: {
                curr = current.getElement();
                if (!curr.isJsonObject()) break block3;
                JsonObject obj = curr.getAsJsonObject();
                ArrayDeque<Node> deque = new ArrayDeque<Node>(current.getChildrenOr(new ArrayList<Node>()));
                while (!deque.isEmpty()) {
                    Node child = (Node)deque.pop();
                    ComponentTreeConstantsAdapter.debug("[1] Searching constant for child " + String.valueOf(child));
                    this.traverseJson(child, relatedConstants);
                    JsonElement childElementCopy = GsonHelper.deepCopy(child.getElement());
                    List<ConstantInfo> constants = ConstantInfo.find(child, relatedConstants);
                    map.put(child, constants);
                    for (ConstantInfo constant : constants) {
                        ConstantInfo parentConstant = this.findParentConstant(constant, relatedConstants);
                        if (parentConstant == null) continue;
                        ((List)map.getOrDefault(current, new ArrayList())).add(parentConstant);
                    }
                }
                break block4;
            }
            if (!curr.isJsonArray()) break block4;
            JsonArray arr = curr.getAsJsonArray();
            for (int i = 0; i < arr.size(); ++i) {
                JsonElement childElement = arr.get(i);
                this.traverseJson(new Node(current, null, i, childElement), relatedConstants);
            }
        }
    }

    private void moveInObject(Node current, Node newParent, KeyRemoval keyRemoval) {
        JsonElement curr = current.getElement();
        JsonElement parent = newParent.getElement();
        if (!curr.isJsonObject() || !parent.isJsonObject()) {
            return;
        }
        for (Node child : current.getChildrenOr(new ArrayList<Node>())) {
            for (ConstantInfo constant : keyRemoval.childrenToMove()) {
                if (!constant.matches(child)) continue;
                child.moveToObject(newParent);
                ComponentTreeConstantsAdapter.debug("    [3] Moved in " + String.valueOf(child) + " to " + String.valueOf(parent));
            }
        }
    }

    private void undoTransferArray(Node current, Node newParent) {
        JsonElement curr = current.getElement();
        JsonElement parent = newParent.getElement();
        if (!curr.isJsonArray() || !parent.isJsonArray()) {
            return;
        }
        for (Node child : current.getChildrenOr(new ArrayList<Node>())) {
            child.moveToArray(newParent);
            ComponentTreeConstantsAdapter.debug("    [3] Moved in keys " + String.valueOf(child) + " to " + String.valueOf(parent));
        }
    }

    private List<ConstantInfo> getRelatedConstantInfos() {
        ArrayList<ConstantInfo> list = new ArrayList<ConstantInfo>();
        for (ConstantInfo constant : UNSTABLE_CONSTANT_INFO_LIST) {
            int modifyVersion = Util.parseVersion(constant.sinceVersion());
            if (modifyVersion <= this.aimingVersion || modifyVersion > this.componentVersion) continue;
            list.add(constant);
        }
        list.sort(Comparator.reverseOrder());
        return list;
    }

    private ConstantInfo findParentConstant(ConstantInfo child, Collection<ConstantInfo> relatedConstants) {
        return relatedConstants.stream().filter(constant -> {
            KeyRemoval keyRemoval = constant.keyRemoval();
            return keyRemoval != null && keyRemoval.childrenToMove().contains(child);
        }).findFirst().orElse(null);
    }

    private static String convertUUID(int[] ints) {
        long most = (long)ints[0] << 32 | (long)ints[1] & 0xFFFFFFFFL;
        long least = (long)ints[2] << 32 | (long)ints[3] & 0xFFFFFFFFL;
        return new UUID(most, least).toString();
    }
}

