/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.shaded.dapi.adventure;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dmentions.shaded.dapi.util.DAPIException;

@ApiStatus.Experimental
public class CompatComponentSerializer {
    private final String adventureVersion;
    private final Class<?> componentClass;
    private final Object gsonInstance;
    private final Object jsonParserInstance;
    private final Method serializeMethod;
    private final Method deserializeMethod;
    private final Method parseStringMethod;

    @NotNull
    public static CompatComponentSerializer newInstance(Class<?> gsonComponentSerializerClass) {
        return new CompatComponentSerializer(gsonComponentSerializerClass);
    }

    private CompatComponentSerializer(Class<?> gsonComponentSerializerClass) {
        this.adventureVersion = gsonComponentSerializerClass.getPackage().getImplementationVersion();
        try {
            Method gsonMethod = gsonComponentSerializerClass.getDeclaredMethod("gson", new Class[0]);
            gsonMethod.setAccessible(true);
            this.gsonInstance = gsonMethod.invoke(null, new Object[0]);
            Method foundSerialize = null;
            Method foundDeserialize = null;
            Method foundParseString = null;
            Class<?> foundComponent = null;
            Object foundJsonParserInstance = null;
            for (Method m : gsonComponentSerializerClass.getDeclaredMethods()) {
                Class<?>[] params = m.getParameterTypes();
                if (m.getName().equals("serializeToTree") && params.length == 1) {
                    foundSerialize = m;
                    foundComponent = params[0];
                    continue;
                }
                if (!m.getName().equals("deserializeFromTree") || params.length != 1) continue;
                foundDeserialize = m;
                Class<?> foundJsonElement = params[0];
                Class<?> jsonParser = null;
                try {
                    jsonParser = Class.forName(foundJsonElement.getPackageName() + ".JsonParser");
                    foundJsonParserInstance = jsonParser.getConstructor(new Class[0]).newInstance(new Object[0]);
                    foundParseString = jsonParser.getDeclaredMethod("parse", String.class);
                }
                catch (ClassNotFoundException | InstantiationException | NoSuchMethodException e) {
                    throw new DAPIException("Failed to find parse method in " + String.valueOf(jsonParser));
                }
            }
            if (foundSerialize == null || foundDeserialize == null) {
                throw new DAPIException("Failed to find serialize/deserialize methods in " + String.valueOf(gsonComponentSerializerClass));
            }
            foundSerialize.setAccessible(true);
            foundDeserialize.setAccessible(true);
            foundParseString.setAccessible(true);
            this.jsonParserInstance = foundJsonParserInstance;
            this.serializeMethod = foundSerialize;
            this.deserializeMethod = foundDeserialize;
            this.parseStringMethod = foundParseString;
            this.componentClass = foundComponent;
        }
        catch (NoSuchMethodException e) {
            throw new DAPIException("Failed to find gson() method in " + String.valueOf(gsonComponentSerializerClass) + ". " + String.valueOf(e));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new DAPIException("Failed to invoke gson() method in " + String.valueOf(gsonComponentSerializerClass) + ". " + String.valueOf(e));
        }
    }

    public String serialize(Object component) {
        try {
            return this.serializeMethod.invoke(this.gsonInstance, component).toString();
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new DAPIException("Failed to serialize the Component to a String. " + String.valueOf(e));
        }
    }

    public Object deserialize(String jsonString) {
        try {
            Object jsonElement = this.parseStringMethod.invoke(this.jsonParserInstance, jsonString);
            return this.deserializeMethod.invoke(this.gsonInstance, jsonElement);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new DAPIException("Failed to deserialize the JsonElement to a Component. " + String.valueOf(e));
        }
    }

    @Generated
    public String getAdventureVersion() {
        return this.adventureVersion;
    }
}

