/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.service.message;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dmentions.service.LanguageManager;
import org.nandayo.dmentions.service.message.MessageRouter;
import org.nandayo.dmentions.service.message.Parameterized;

public class Message {
    private static final Map<String, Message> KEY_MAP = new HashMap<String, Message>();
    private static final String UNSET_VALUE = "?LM?";
    @Parameterized(params={"{remained}"})
    public static final Message COOLDOWN_WARN = Message.create("cooldown_warn");
    @Parameterized(params={"{target}"})
    public static final Message MENTION_RESTRICTED_WARN = Message.create("mention_restricted_warn");
    @Parameterized(params={"{world}"})
    public static final Message DISABLED_WORLD_WARN = Message.create("disabled_world_warn");
    @Parameterized(params={"{target}"})
    public static final Message AFK_WARN = Message.create("afk_warn");
    @Parameterized(params={"{target}"})
    public static final Message IGNORE_WARN = Message.create("ignore_warn");
    public static final Message VANISH_NOTIFY_X = Message.create("vanish_notify.{x}");
    @Parameterized(params={"{target}", "{sender}"})
    public static final Message PLAYER_SENDER_MESSAGE = Message.create("player.sender_message");
    @Parameterized(params={"{target}", "{sender}"})
    public static final Message PLAYER_TARGET_MESSAGE = Message.create("player.target_message");
    @Parameterized(params={"{sender}"})
    public static final Message NEARBY_SENDER_MESSAGE = Message.create("nearby.sender_message");
    @Parameterized(params={"{sender}"})
    public static final Message NEARBY_TARGET_MESSAGE = Message.create("nearby.target_message");
    @Parameterized(params={"{sender}"})
    public static final Message EVERYONE_SENDER_MESSAGE = Message.create("everyone.sender_message");
    @Parameterized(params={"{sender}"})
    public static final Message EVERYONE_TARGET_MESSAGE = Message.create("everyone.target_message");
    @Parameterized(params={"{sender}", "{group}"})
    public static final Message GROUP_X_SENDER_MESSAGE = Message.create("group.{x}.sender_message");
    @Parameterized(params={"{sender}", "{group}"})
    public static final Message GROUP_X_TARGET_MESSAGE = Message.create("group.{x}.target_message");
    public static final Message COMMAND_MUST_BE_PLAYER = Message.create("command.must_be_player");
    public static final Message COMMAND_PLAYER_NOT_FOUND = Message.create("command.player_not_found");
    public static final Message COMMAND_USER_NOT_FOUND = Message.create("command.user_not_found");
    public static final Message COMMAND_UNKNOWN = Message.create("command.unknown");
    public static final Message COMMAND_TOGGLE_NO_LONGER_MENTIONED = Message.create("command.toggle.no_longer_mentioned");
    public static final Message COMMAND_TOGGLE_WILL_NOW_MENTIONED = Message.create("command.toggle.will_now_mentioned");
    public static final Message COMMAND_SEND_INVALID_KEYWORD = Message.create("command.send.invalid_keyword");
    public static final Message COMMAND_RELOAD_SUCCESS = Message.create("command.reload.success");
    public static final Message COMMAND_USER_UNKNOWN = Message.create("command.user.unknown");
    @Parameterized(params={"{target}", "{value}"})
    public static final Message COMMAND_USER_MENTIONS_SUCCESS = Message.create("command.user.mentions.success");
    public static final Message COMMAND_USER_DISPLAY_INVALID_DISPLAY = Message.create("command.user.display.invalid_display");
    @Parameterized(params={"{target}", "{value}"})
    public static final Message COMMAND_USER_DISPLAY_SUCCESS = Message.create("command.user.display.success");
    public static final Message COMMAND_HELP_DESCRIPTION = Message.create("command.help.description");
    @Parameterized(params={"{commands}"})
    public static final Message COMMAND_HELP_LIST = Message.create("command.help.list");
    public static final Message COMMAND_CONFIG_ALREADY_CONFIGURING = Message.create("command.config.already_configuring");
    public static final Message COMMAND_CONFIG_RESET_CHANGES = Message.create("command.config.reset_changes");
    public static final Message COMMAND_CONFIG_SAVE_CHANGES = Message.create("command.config.save_changes");
    public static final Message COMMAND_CUSTOMIZE_INVALID_DISPLAY = Message.create("command.customize.invalid_display");
    @Parameterized(params={"{old_value}", "{value}"})
    public static final Message COMMAND_CUSTOMIZE_SUCCESS = Message.create("command.customize.success");
    @NotNull
    private final String key;
    @NotNull
    private Object value = "?LM?";
    private static LanguageManager languageManager;

    protected Message(@NotNull String key) {
        this.key = key;
    }

    protected Message(@NotNull String key, @NotNull Object value) {
        this.key = key;
        this.value = value;
    }

    @NotNull
    public Object getValue() {
        if (this.value.equals(UNSET_VALUE)) {
            this.value = languageManager.get(this.key);
        }
        return this.value;
    }

    protected static Message create(String key) {
        Message message = new Message(key);
        KEY_MAP.put(key, message);
        return message;
    }

    public Message replaceKey(@NotNull String regex, @NotNull String replacement) {
        return new Message(this.key.replace(regex, replacement));
    }

    public Message replaceValue(@NotNull String regex, @NotNull String replacement) {
        ArrayList<String> value = this.getValue();
        if (value instanceof String) {
            value = ((String)((Object)value)).replace(regex, replacement);
        } else if (value instanceof List) {
            ArrayList<String> list = new ArrayList<String>();
            for (Object o : (List)value) {
                if (!(o instanceof String)) continue;
                list.add(((String)o).replace(regex, replacement));
            }
            value = list;
        }
        return new Message(this.key, value);
    }

    protected static Map<String, Message> getKeyMap() {
        return new HashMap<String, Message>(KEY_MAP);
    }

    public static void init(@NotNull LanguageManager languageManager) {
        Message.resetValues();
        Message.languageManager = languageManager;
    }

    private static void resetValues() {
        for (Message message : KEY_MAP.values()) {
            message.value = UNSET_VALUE;
        }
    }

    public void sendMessage(@NotNull CommandSender receiver) {
        Object obj = this.getValue();
        if (obj instanceof String) {
            MessageRouter.sendResolved(receiver, (String)obj);
        } else if (obj instanceof List) {
            for (Object o : (List)obj) {
                if (!(o instanceof String)) continue;
                MessageRouter.sendResolved(receiver, (String)o);
            }
        }
    }

    @NotNull
    @Generated
    public String getKey() {
        return this.key;
    }
}

