/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.service;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Scanner;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.service.Config;
import org.nandayo.dmentions.shaded.dapi.util.Util;

public class UpdateChecker {
    private static final int RESOURCE_ID = 121452;
    public static final UpdateChecker INSTANCE = new UpdateChecker();
    private boolean isChecked = false;

    private UpdateChecker() {
    }

    public void check(@NotNull DMentions plugin) {
        if (this.isChecked) {
            return;
        }
        this.isChecked = true;
        if (!this.isCheckerEnabled(plugin.getConfiguration())) {
            return;
        }
        this.fetchLatest(plugin, latest -> {
            if (plugin.getDescription().getVersion().equals(latest)) {
                Util.log("&aPlugin is up-to-date.");
            } else {
                Util.log("&fThere is a new version update. (&e" + latest + "&f)");
            }
        });
    }

    private boolean isCheckerEnabled(@NotNull Config config) {
        return config.getConfig().getBoolean("check_for_updates", true);
    }

    private void fetchLatest(@NotNull DMentions plugin, @NotNull Consumer<String> consumer) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            try (InputStream is = new URL("https://api.spigotmc.org/legacy/update.php?resource=121452/~").openStream();
                 Scanner scann = new Scanner(is);){
                if (scann.hasNext()) {
                    consumer.accept(scann.next());
                }
            }
            catch (IOException | IllegalStateException e) {
                Util.log("&cUnable to check for updates: " + e.getMessage());
            }
        });
    }
}

