/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.service;

import java.util.HashMap;
import java.util.Locale;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.enumeration.MentionType;
import org.nandayo.dmentions.model.Cooldown;
import org.nandayo.dmentions.service.Config;
import org.nandayo.dmentions.service.message.Message;
import org.nandayo.dmentions.util.DUtil;

public class CooldownManager {
    @NotNull
    private final DMentions plugin;
    private final HashMap<MentionType, Cooldown<String>> COOLDOWN_MAP_MS = new HashMap();
    private final HashMap<String, Long> CONFIG_COOLDOWN_MS = new HashMap();

    public CooldownManager(@NotNull DMentions plugin) {
        this.plugin = plugin;
    }

    public void updateLastUse(@NotNull MentionType mentionType, @Nullable String name) {
        this.COOLDOWN_MAP_MS.computeIfAbsent(mentionType, k -> new Cooldown()).update(name);
    }

    public long getRemaining(@NotNull MentionType mentionType, @Nullable String name) {
        return this.COOLDOWN_MAP_MS.computeIfAbsent(mentionType, k -> new Cooldown()).getRemaining(name, this.getConfigCooldown(mentionType, name));
    }

    public void removeCooldown(@NotNull MentionType mentionType, @Nullable String name) {
        Cooldown<String> cooldown = this.COOLDOWN_MAP_MS.get((Object)mentionType);
        if (cooldown != null) {
            cooldown.remove(name);
        }
    }

    public void updateConfigCooldowns() {
        this.CONFIG_COOLDOWN_MS.clear();
        Config config = this.plugin.getConfiguration();
        this.CONFIG_COOLDOWN_MS.put("player", config.getConfig().getLong("player.cooldown", 0L) * 1000L);
        this.CONFIG_COOLDOWN_MS.put("nearby", config.getConfig().getLong("nearby.cooldown", 0L) * 1000L);
        this.CONFIG_COOLDOWN_MS.put("everyone", config.getConfig().getLong("everyone.cooldown", 0L) * 1000L);
        ConfigurationSection groupSection = config.getConfig().getConfigurationSection("group.list");
        if (groupSection == null) {
            return;
        }
        for (String group : groupSection.getKeys(false)) {
            if (config.getConfig().getStringList("group.disabled_groups").contains(group)) continue;
            this.CONFIG_COOLDOWN_MS.put("group_" + group, groupSection.getLong(group + ".cooldown", 0L) * 1000L);
        }
    }

    private long getConfigCooldown(@NotNull MentionType mentionType, @Nullable String name) {
        switch (mentionType) {
            case PLAYER: 
            case NEARBY: 
            case EVERYONE: {
                return this.CONFIG_COOLDOWN_MS.getOrDefault(mentionType.name().toLowerCase(Locale.ENGLISH), 0L);
            }
            case GROUP: {
                return this.CONFIG_COOLDOWN_MS.get("group_" + DUtil.getGroupConfigKey(name));
            }
        }
        return 0L;
    }

    public void cooldownWarn(@NotNull Player sender, long remaining) {
        if (remaining <= 0L) {
            return;
        }
        Message.COOLDOWN_WARN.replaceValue("{remained}", DUtil.formattedTime(remaining)).sendMessage((CommandSender)sender);
    }
}

