/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.menu;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.enumeration.MentionType;
import org.nandayo.dmentions.integration.LuckPermsHook;
import org.nandayo.dmentions.menu.BaseMenu;
import org.nandayo.dmentions.menu.MentionSettingsMenu;
import org.nandayo.dmentions.menu.MentionTypeSettingsMenu;
import org.nandayo.dmentions.shaded.dapi.guimanager.MenuType;
import org.nandayo.dmentions.shaded.dapi.guimanager.button.Button;
import org.nandayo.dmentions.shaded.dapi.util.ItemCreator;

public class SubMentionAddGroupMenu
extends BaseMenu {
    private final LuckPermsHook luckPermsHook;

    public SubMentionAddGroupMenu(@NotNull DMentions plugin, @NotNull Player player) {
        super(plugin, player);
        this.luckPermsHook = plugin.getLuckPermsHook();
        this.open();
    }

    @Override
    protected void open() {
        final ConfigurationSection menuSection = this.guiRegistry.getSection("menu.add_group_menu");
        this.createInventory(MenuType.CHEST_6_ROWS, this.guiRegistry.getString(menuSection, "title"));
        ConfigurationSection section = this.config.getUnsavedConfig().getConfigurationSection("group.list");
        List disabledGroups = this.config.getUnsavedConfig().getStringList("group.disabled_groups");
        if (!this.luckPermsHook.isMaskNull() && section != null) {
            int i = 0;
            for (final String group : this.luckPermsHook.getGroups()) {
                if (section.contains(group) || disabledGroups.contains(group)) continue;
                final int slot = i++;
                this.addButton(new Button(){
                    final String langPathName = "not_added_group";

                    @Override
                    @NotNull
                    public Set<Integer> getSlots() {
                        return Sets.newHashSet((Object[])new Integer[]{slot});
                    }

                    @Override
                    public ItemStack getItem() {
                        return ItemCreator.of(Material.YELLOW_BANNER).name(SubMentionAddGroupMenu.this.guiRegistry.getString(menuSection, "not_added_group.display_name").replace("{group}", group)).lore(SubMentionAddGroupMenu.this.guiRegistry.getStringList(menuSection, "not_added_group.lore")).get();
                    }

                    @Override
                    public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                        SubMentionAddGroupMenu.this.config.getUnsavedConfig().set("group.list." + group + ".sound", (Object)"block.note_block.pling");
                        SubMentionAddGroupMenu.this.config.getUnsavedConfig().set("group.list." + group + ".display", (Object)"&#73c7dc@{group}");
                        SubMentionAddGroupMenu.this.config.getUnsavedConfig().set("group.list." + group + ".cooldown", (Object)5);
                        new MentionTypeSettingsMenu(SubMentionAddGroupMenu.this.plugin, SubMentionAddGroupMenu.this.player, MentionType.GROUP, group);
                    }
                });
            }
        }
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{45});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.ARROW).name(SubMentionAddGroupMenu.this.guiRegistry.getString("menu.back.display_name")).lore(SubMentionAddGroupMenu.this.guiRegistry.getStringList("menu.back.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new MentionSettingsMenu(SubMentionAddGroupMenu.this.plugin, SubMentionAddGroupMenu.this.player);
            }
        });
        this.displayTo(this.player);
        this.plugin.setGuiConfigEditor(this.player);
    }
}

