/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.menu;

import com.google.common.collect.Sets;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.menu.BaseMenu;
import org.nandayo.dmentions.menu.GeneralSettingsMenu;
import org.nandayo.dmentions.shaded.dapi.guimanager.MenuType;
import org.nandayo.dmentions.shaded.dapi.guimanager.button.Button;
import org.nandayo.dmentions.shaded.dapi.util.ItemCreator;

public class SubLanguageMenu
extends BaseMenu {
    public SubLanguageMenu(@NotNull DMentions plugin, @NotNull Player player) {
        super(plugin, player);
        this.open();
    }

    @Override
    protected void open() {
        final ConfigurationSection menuSection = this.guiRegistry.getSection("menu.language_menu");
        this.createInventory(MenuType.CHEST_6_ROWS, this.guiRegistry.getString(menuSection, "title"));
        int i = 0;
        for (final String lang : this.plugin.getLanguageManager().REGISTERED_LANGUAGES) {
            final int slot = i++;
            this.addButton(new Button(){
                final String langPathName = "language";

                @Override
                @NotNull
                public Set<Integer> getSlots() {
                    return Sets.newHashSet((Object[])new Integer[]{slot});
                }

                @Override
                public ItemStack getItem() {
                    return ItemCreator.of(Material.BOOK).name(SubLanguageMenu.this.guiRegistry.getString(menuSection, "language.display_name").replace("{language}", lang)).lore(SubLanguageMenu.this.guiRegistry.getStringList(menuSection, "language.lore")).get();
                }

                @Override
                public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                    SubLanguageMenu.this.config.getUnsavedConfig().set("lang_file", (Object)lang);
                    new GeneralSettingsMenu(SubLanguageMenu.this.plugin, SubLanguageMenu.this.player);
                }
            });
        }
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{45});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.ARROW).name(SubLanguageMenu.this.guiRegistry.getString("menu.back.display_name")).lore(SubLanguageMenu.this.guiRegistry.getStringList("menu.back.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new GeneralSettingsMenu(SubLanguageMenu.this.plugin, SubLanguageMenu.this.player);
            }
        });
        this.displayTo(this.player);
        this.plugin.setGuiConfigEditor(this.player);
    }
}

