/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.menu;

import com.google.common.collect.Sets;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.enumeration.MentionType;
import org.nandayo.dmentions.menu.BaseMenu;
import org.nandayo.dmentions.menu.MentionSettingsMenu;
import org.nandayo.dmentions.menu.MentionTypeSettingsMenu;
import org.nandayo.dmentions.shaded.dapi.guimanager.MenuType;
import org.nandayo.dmentions.shaded.dapi.guimanager.button.Button;
import org.nandayo.dmentions.shaded.dapi.util.ItemCreator;

public class SubChooseGroupMenu
extends BaseMenu {
    public SubChooseGroupMenu(@NotNull DMentions plugin, @NotNull Player player) {
        super(plugin, player);
        this.open();
    }

    @Override
    protected void open() {
        final ConfigurationSection menuSection = this.guiRegistry.getSection("menu.choose_group_menu");
        this.createInventory(MenuType.CHEST_6_ROWS, this.guiRegistry.getString(menuSection, "title"));
        int i = 0;
        ConfigurationSection section = this.config.getUnsavedConfig().getConfigurationSection("group.list");
        if (section != null) {
            for (final String group : section.getKeys(false)) {
                final int slot = i++;
                this.addButton(new Button(){

                    @Override
                    @NotNull
                    public Set<Integer> getSlots() {
                        return Sets.newHashSet((Object[])new Integer[]{slot});
                    }

                    @Override
                    public ItemStack getItem() {
                        return ItemCreator.of(Material.GREEN_BANNER).name(SubChooseGroupMenu.this.guiRegistry.getString(menuSection, "group.display_name").replace("{group}", group)).lore(SubChooseGroupMenu.this.guiRegistry.getStringList(menuSection, "group.lore")).get();
                    }

                    @Override
                    public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                        new MentionTypeSettingsMenu(SubChooseGroupMenu.this.plugin, SubChooseGroupMenu.this.player, MentionType.GROUP, group);
                    }
                });
            }
        }
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{45});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.ARROW).name(SubChooseGroupMenu.this.guiRegistry.getString("menu.back.display_name")).lore(SubChooseGroupMenu.this.guiRegistry.getStringList("menu.back.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new MentionSettingsMenu(SubChooseGroupMenu.this.plugin, SubChooseGroupMenu.this.player);
            }
        });
        this.displayTo(this.player);
        this.plugin.setGuiConfigEditor(this.player);
    }
}

