/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.menu;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.service.Config;
import org.nandayo.dmentions.shaded.dapi.guimanager.button.Button;
import org.nandayo.dmentions.shaded.dapi.guimanager.menu.AnvilMenu;
import org.nandayo.dmentions.shaded.dapi.util.ItemCreator;

public class AnvilManager
extends AnvilMenu {
    private final Config config;
    private final Player player;
    private final String path;
    private final String title;
    private final Consumer<String> onFinish;

    public AnvilManager(DMentions plugin, Player player, String path, String title, Consumer<String> onFinish) {
        this.config = plugin.getConfiguration();
        this.player = player;
        this.path = path;
        this.title = title;
        this.onFinish = onFinish;
        this.open();
    }

    private void open() {
        this.createInventory(this.player, this.title);
        this.addButton(new Button(){

            @Override
            @NotNull
            protected Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{0});
            }

            @Override
            @Nullable
            public ItemStack getItem() {
                ItemStack item = new ItemStack(Material.PAPER);
                ItemMeta meta = item.getItemMeta();
                if (meta != null) {
                    meta.setDisplayName(AnvilManager.this.config.getUnsavedConfig().getString(AnvilManager.this.path, ""));
                    item.setItemMeta(meta);
                }
                return item;
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            protected Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{2});
            }

            @Override
            @Nullable
            public ItemStack getItem() {
                return ItemCreator.of(Material.NAME_TAG).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                String text = AnvilManager.this.getText();
                AnvilManager.this.onFinish.accept(text == null ? "" : text);
            }
        });
        this.displayTo(this.player);
    }
}

