/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.integration;

import net.shortninja.staffplusplus.IStaffPlus;
import net.shortninja.staffplusplus.session.IPlayerSession;
import net.shortninja.staffplusplus.vanish.VanishOffEvent;
import net.shortninja.staffplusplus.vanish.VanishOnEvent;
import net.shortninja.staffplusplus.vanish.VanishType;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.integration.IHook;
import org.nandayo.dmentions.provider.VanishProvider;

public class StaffPPHook
implements IHook,
VanishProvider {
    @NotNull
    private final DMentions plugin;
    private Object mask = null;

    public StaffPPHook(@NotNull DMentions plugin) {
        this.plugin = plugin;
        this.pluginCondition("StaffPlusPlus", spp -> {
            RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(IStaffPlus.class);
            if (provider != null) {
                this.mask = provider.getProvider();
            }
        });
    }

    @Override
    @Nullable
    public Object mask() {
        return this.mask;
    }

    private IStaffPlus getAPI() {
        return (IStaffPlus)this.mask;
    }

    @Override
    public boolean isVanished(Player player) {
        if (player == null || this.isMaskNull()) {
            return false;
        }
        IPlayerSession session = this.getAPI().getSessionManager().get(player);
        if (session == null) {
            return false;
        }
        VanishType vanishType = session.getVanishType();
        return vanishType != null && StaffPPHook.isVanish(vanishType);
    }

    private static boolean isVanish(VanishType vanishType) {
        switch (vanishType) {
            case LIST: 
            case TOTAL: {
                return true;
            }
        }
        return false;
    }

    public static class StaffPlusPlusListener
    implements Listener {
        @NotNull
        private final DMentions plugin;

        public StaffPlusPlusListener(@NotNull DMentions plugin) {
            this.plugin = plugin;
        }

        @EventHandler
        public void onVanishOn(VanishOnEvent event) {
            if (!this.plugin.getConfiguration().getConfig().getBoolean("vanish_respect", true)) {
                return;
            }
            if (!StaffPPHook.isVanish(event.getType())) {
                return;
            }
            Player player = event.getPlayer();
            this.plugin.getMentionManager().removePlayer(player);
        }

        @EventHandler
        public void onVanishOff(VanishOffEvent event) {
            if (!this.plugin.getConfiguration().getConfig().getBoolean("vanish_respect", true)) {
                return;
            }
            if (!StaffPPHook.isVanish(event.getType())) {
                return;
            }
            Player player = event.getPlayer();
            this.plugin.getMentionManager().addPlayer(player);
        }
    }
}

