/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.integration;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.user.User;
import net.luckperms.api.query.QueryOptions;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.integration.IHook;

public class LuckPermsHook
implements IHook {
    private static final Map<UUID, String> playerGroupCache = new HashMap<UUID, String>();
    @NotNull
    private final DMentions plugin;
    private Object mask = null;

    public LuckPermsHook(@NotNull DMentions plugin) {
        this.plugin = plugin;
        this.pluginCondition("LuckPerms", lp -> {
            RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(LuckPerms.class);
            if (provider != null) {
                this.mask = provider.getProvider();
            }
        });
    }

    @Override
    public Object mask() {
        return this.mask;
    }

    public LuckPerms getAPI() {
        return (LuckPerms)this.mask;
    }

    public List<String> getGroups() {
        if (this.isMaskNull()) {
            return new ArrayList<String>();
        }
        return this.getAPI().getGroupManager().getLoadedGroups().stream().map(Group::getName).collect(Collectors.toList());
    }

    public Player[] getOnlinePlayersInGroup(String groupName) {
        if (this.isMaskNull() || groupName == null || groupName.isEmpty()) {
            return new Player[0];
        }
        return (Player[])Bukkit.getOnlinePlayers().stream().filter(player -> {
            User user = this.getAPI().getUserManager().getUser(player.getUniqueId());
            if (user == null) {
                return false;
            }
            return this.getGroup((Player)player).equals(groupName);
        }).toArray(Player[]::new);
    }

    @Nullable
    public String getGroup(Player player) {
        String group = playerGroupCache.get(player.getUniqueId());
        return group != null ? group : this.updatePlayerGroupCache(player);
    }

    public String updatePlayerGroupCache(Player player) {
        String group = this.getHighestPriorityGroup(player);
        if (group != null) {
            playerGroupCache.put(player.getUniqueId(), group);
        }
        return group;
    }

    @Nullable
    private String getHighestPriorityGroup(Player player) {
        if (this.isMaskNull()) {
            return null;
        }
        LuckPerms api = this.getAPI();
        User user = api.getUserManager().getUser(player.getUniqueId());
        if (user == null) {
            return null;
        }
        QueryOptions queryOptions = api.getContextManager().getQueryOptions(user).orElse(null);
        if (queryOptions == null) {
            return null;
        }
        return user.getInheritedGroups(queryOptions).stream().max(Comparator.comparingInt(g -> g.getWeight().orElse(0))).map(Group::getName).orElse(user.getPrimaryGroup());
    }
}

