/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.event;

import java.util.Arrays;
import java.util.List;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.event.MentionEveryoneEvent;
import org.nandayo.dmentions.event.MentionGroupEvent;
import org.nandayo.dmentions.event.MentionNearbyEvent;
import org.nandayo.dmentions.event.MentionPlayerEvent;
import org.nandayo.dmentions.model.SoundProperty;
import org.nandayo.dmentions.provider.VanishProvider;
import org.nandayo.dmentions.service.Config;
import org.nandayo.dmentions.service.message.Message;
import org.nandayo.dmentions.util.DUtil;

public class PluginEvents
implements Listener {
    public static final PluginEvents INSTANCE = new PluginEvents();

    private PluginEvents() {
    }

    @EventHandler
    public void onPlayerMention(MentionPlayerEvent e) {
        Player sender = e.getSender();
        Player target = e.getTarget();
        Config config = DMentions.inst().getConfiguration();
        SoundProperty soundProperty = SoundProperty.deserialize(config.getConfig().getString("player.sound", ""));
        Message targetMessage = Message.PLAYER_TARGET_MESSAGE.replaceValue("{sender}", sender.getName()).replaceValue("{target}", target.getName());
        Message senderMessage = Message.PLAYER_SENDER_MESSAGE.replaceValue("{target}", target.getName()).replaceValue("{sender}", sender.getName());
        this.mention(sender, new Player[]{target}, soundProperty, targetMessage, senderMessage);
    }

    @EventHandler
    public void onNearbyMention(MentionNearbyEvent e) {
        Player sender = e.getSender();
        Player[] targets = e.getTargets();
        Config config = DMentions.inst().getConfiguration();
        SoundProperty soundProperty = SoundProperty.deserialize(config.getConfig().getString("nearby.sound", ""));
        Message targetMessage = Message.NEARBY_TARGET_MESSAGE.replaceValue("{sender}", sender.getName());
        Message senderMessage = Message.NEARBY_SENDER_MESSAGE.replaceValue("{sender}", sender.getName());
        this.mention(sender, targets, soundProperty, targetMessage, senderMessage);
    }

    @EventHandler
    public void onEveryoneMention(MentionEveryoneEvent e) {
        Player sender = e.getSender();
        Player[] targets = e.getTargets();
        Config config = DMentions.inst().getConfiguration();
        SoundProperty soundProperty = SoundProperty.deserialize(config.getConfig().getString("everyone.sound", ""));
        Message targetMessage = Message.EVERYONE_TARGET_MESSAGE.replaceValue("{sender}", sender.getName());
        Message senderMessage = Message.EVERYONE_SENDER_MESSAGE.replaceValue("{sender}", sender.getName());
        this.mention(sender, targets, soundProperty, targetMessage, senderMessage);
    }

    @EventHandler
    public void onGroupMention(MentionGroupEvent e) {
        Player sender = e.getSender();
        String group = e.getGroup();
        Player[] targets = e.getTargets();
        String groupLanguageKey = DUtil.getGroupLanguageKey(group);
        ConfigurationSection configSection = DUtil.getGroupConfigSection(group);
        if (configSection == null) {
            return;
        }
        SoundProperty soundProperty = SoundProperty.deserialize(configSection.getString("sound", ""));
        Message targetMessage = Message.GROUP_X_TARGET_MESSAGE.replaceKey("{x}", groupLanguageKey).replaceValue("{sender}", sender.getName()).replaceValue("{group}", group);
        Message senderMessage = Message.GROUP_X_SENDER_MESSAGE.replaceKey("{x}", groupLanguageKey).replaceValue("{sender}", sender.getName()).replaceValue("{group}", group);
        this.mention(sender, targets, soundProperty, targetMessage, senderMessage);
    }

    private void mention(final @NotNull Player sender, final @NotNull Player[] targets, final @NotNull SoundProperty soundProperty, final @NotNull Message targetMessage, @NotNull Message senderMessage) {
        final DMentions plugin = DMentions.inst();
        final Sound sound = plugin.getWrapper().getSound(soundProperty.getKey());
        senderMessage.sendMessage((CommandSender)sender);
        if (sound != null) {
            plugin.getWrapper().playSound(sender, sound, soundProperty.getVolume(), soundProperty.getPitch());
        }
        new BukkitRunnable(){
            int counter = 0;
            final List<Player> targetList = Arrays.asList(targets);
            final boolean ignoreRespect = plugin.getConfiguration().getConfig().getBoolean("ignore_respect", true);
            final boolean afkRespect = plugin.getConfiguration().getConfig().getBoolean("afk_respect", false);
            final boolean vanishRespect = plugin.getConfiguration().getConfig().getBoolean("vanish_respect", true);

            public void run() {
                for (int i = 0; i < 30; ++i) {
                    boolean isVanished;
                    if (this.counter >= this.targetList.size()) {
                        this.cancel();
                        break;
                    }
                    Player target = this.targetList.get(this.counter++);
                    boolean isIgnored = this.ignoreRespect && plugin.getEssentialsHook().isIgnored(sender, target);
                    boolean isAFK = this.afkRespect && plugin.getEssentialsHook().isAFK(target);
                    boolean bl = isVanished = this.vanishRespect && VanishProvider.get().isVanished(target);
                    if (target == null || target.equals((Object)sender) || DUtil.isRestricted(sender, target) || isIgnored || isAFK || isVanished) continue;
                    if (sound != null) {
                        plugin.getWrapper().playSound(target, sound, soundProperty.getVolume(), soundProperty.getPitch());
                    }
                    targetMessage.sendMessage((CommandSender)target);
                }
            }
        }.runTaskTimer((Plugin)plugin, 0L, 10L);
    }
}

