/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.anvilmenu.nms;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public enum NMSVersion {
    V1_16_R1(1601),
    V1_16_R2(1602, 1603),
    V1_16_R3(1604, 1605),
    V1_17_R1(1700),
    V1_17_1_R1(1701),
    V1_18_R1(1800, 1801),
    V1_18_R2(1802),
    V1_19_0_R1(1900),
    V1_19_R1(1901, 1902),
    V1_19_R2(1903),
    V1_19_R3(1904),
    V1_20_R1(2000, 2001),
    V1_20_R2(2002),
    V1_20_R3(2003, 2004),
    V1_20_R4(2005, 2006),
    V1_21_R1(2100, 2101),
    V1_21_R2(2102, 2103),
    V1_21_R3(2104),
    V1_21_R4(2105),
    V1_21_R5(2106, 2107, 2108),
    V1_21_R6(2109, 2110);

    private final int[] minecraftVersions;
    private static final NMSVersion LATEST;
    @NotNull
    private static final Map<Integer, NMSVersion> VERSION_MAP;

    private NMSVersion(int ... minecraftVersions) {
        this.minecraftVersions = minecraftVersions;
    }

    public String removeV() {
        return this.name().replace("V", "");
    }

    public static NMSVersion findVersion(int minecraftVersion) {
        return VERSION_MAP.getOrDefault(minecraftVersion, LATEST);
    }

    static {
        LATEST = V1_21_R6;
        VERSION_MAP = new HashMap<Integer, NMSVersion>();
        for (NMSVersion version : NMSVersion.values()) {
            for (int i : version.minecraftVersions) {
                VERSION_MAP.put(i, version);
            }
        }
    }
}

