/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.util;

import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.service.Config;
import org.nandayo.dmentions.service.LanguageManager;
import org.nandayo.dmentions.shaded.dapi.object.DEnchantment;
import org.nandayo.dmentions.shaded.dapi.object.DMaterial;

public class DUtil {
    private static final String OTHER_KEY = "__OTHER__";

    @NotNull
    public static String getGroupConfigKey(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            return OTHER_KEY;
        }
        ConfigurationSection section = DMentions.inst().getConfig().getConfigurationSection("group.list");
        if (section == null || !section.contains(groupName)) {
            return OTHER_KEY;
        }
        return groupName;
    }

    @NotNull
    public static String getGroupLanguageKey(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            return OTHER_KEY;
        }
        ConfigurationSection section = DMentions.inst().getConfig().getConfigurationSection("group");
        if (section == null || !section.contains(groupName)) {
            return OTHER_KEY;
        }
        return groupName;
    }

    @Nullable
    public static ConfigurationSection getGroupConfigSection(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            return null;
        }
        Config config = DMentions.inst().getConfiguration();
        if (config.getConfig().getStringList("group.disabled_groups").contains(groupName)) {
            return null;
        }
        return config.getConfig().getConfigurationSection("group.list." + DUtil.getGroupConfigKey(groupName));
    }

    @Nullable
    public static ConfigurationSection getGroupLanguageSection(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            return null;
        }
        LanguageManager languageManager = DMentions.inst().getLanguageManager();
        return languageManager.getSection("group." + DUtil.getGroupLanguageKey(groupName));
    }

    public static String replacePrefixes(String str) {
        if (str == null || str.isEmpty()) {
            return "";
        }
        String prefix = DMentions.inst().getConfiguration().getConfig().getString("prefix", "");
        return str.replaceAll("\\{PREFIX}", prefix);
    }

    public static float parseFloat(String str, float def) {
        if (str == null || str.isEmpty()) {
            return def;
        }
        try {
            return Float.parseFloat(str);
        }
        catch (Exception e) {
            return def;
        }
    }

    public static int parseInt(String str, int def) {
        if (str == null || str.isEmpty()) {
            return def;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    @NotNull
    public static String formattedTime(long millisecond) {
        long seconds = millisecond / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        seconds %= 60L;
        minutes %= 60L;
        hours %= 24L;
        if (days > 0L) {
            return String.format("%d d, %d h", days, hours);
        }
        if (hours > 0L) {
            return String.format("%d h, %d m", hours, minutes);
        }
        if (minutes > 0L) {
            return String.format("%d m, %d s", minutes, seconds);
        }
        return String.format("%d s", seconds);
    }

    public static boolean isRestricted(@NotNull Player sender, @NotNull Player target) {
        if (target.hasPermission("dmentions.mention.restricted")) {
            return !sender.hasPermission("dmentions.mention.restricted.bypass");
        }
        return false;
    }

    public static Enchantment getEnchantment(@NotNull DEnchantment dEnchantment, @NotNull DEnchantment def) {
        Enchantment enchantment = dEnchantment.get();
        if (enchantment != null) {
            return enchantment;
        }
        return def.get();
    }

    public static Material getMaterial(@NotNull DMaterial dMaterial, @NotNull DMaterial def) {
        Material mat = dMaterial.parseMaterial();
        if (mat != null) {
            return mat;
        }
        return def.parseMaterial();
    }
}

