/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.shaded.dapi.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dmentions.shaded.dapi.util.Util;

public class Wrapper {
    private static int minecraftVersion = -1;
    private static Attribute armorAttribute;
    private static AttributeModifier attributeModifier;

    public static int getMinecraftVersion() {
        if (minecraftVersion != -1) {
            return minecraftVersion;
        }
        minecraftVersion = Wrapper.fetchVersion();
        return minecraftVersion;
    }

    private static int fetchVersion() {
        String[] ver = Bukkit.getBukkitVersion().split("-")[0].split("\\.");
        if (ver.length < 2) {
            Util.logInternal("Could not fetch server version!");
            return 165;
        }
        int major = 0;
        try {
            major = Integer.parseInt(ver[1]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int minor = 0;
        if (ver.length >= 3) {
            try {
                minor = Integer.parseInt(ver[2]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return major * 10 + minor;
    }

    public static Attribute getArmorAttribute() {
        if (armorAttribute != null) {
            return armorAttribute;
        }
        Wrapper.setupArmorAttributeModifier();
        return armorAttribute;
    }

    public static AttributeModifier getArmorAttributeModifier() {
        if (attributeModifier != null) {
            return attributeModifier;
        }
        Wrapper.setupArmorAttributeModifier();
        return attributeModifier;
    }

    private static void setupArmorAttributeModifier() {
        if (minecraftVersion >= 213) {
            armorAttribute = Attribute.ARMOR;
            attributeModifier = new AttributeModifier(new NamespacedKey("dapi", "foo"), 0.0, AttributeModifier.Operation.MULTIPLY_SCALAR_1, EquipmentSlotGroup.ANY);
        } else if (minecraftVersion >= 210) {
            try {
                Class<?> attributeClass = Class.forName("org.bukkit.attribute.Attribute");
                armorAttribute = (Attribute)Enum.valueOf(attributeClass, "GENERIC_ARMOR");
            }
            catch (ClassNotFoundException attributeClass) {
                // empty catch block
            }
            attributeModifier = new AttributeModifier(new NamespacedKey("dapi", "foo"), 0.0, AttributeModifier.Operation.MULTIPLY_SCALAR_1, EquipmentSlotGroup.ANY);
        } else {
            try {
                Class<?> attributeClass = Class.forName("org.bukkit.attribute.Attribute");
                armorAttribute = (Attribute)Enum.valueOf(attributeClass, "GENERIC_ARMOR");
            }
            catch (Exception attributeClass) {
                // empty catch block
            }
            try {
                Class<?> modifierClass = Class.forName("org.bukkit.attribute.AttributeModifier");
                Class<?> operationClass = Class.forName("org.bukkit.attribute.AttributeModifier$Operation");
                Object operation = Enum.valueOf(operationClass, "MULTIPLY_SCALAR_1");
                Constructor<?> constructor = modifierClass.getConstructor(String.class, Double.TYPE, operationClass);
                attributeModifier = (AttributeModifier)constructor.newInstance("foo", 0.0, operation);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void editPotionMeta(@NotNull PotionMeta meta, @Nullable PotionType potionType, @Nullable Color color) {
        if (minecraftVersion >= 205) {
            meta.setBasePotionType(potionType);
        } else if (minecraftVersion >= 202) {
            if (potionType != null) {
                meta.setBasePotionType(potionType);
            }
        } else if (potionType != null) {
            try {
                Class<?> potionDataClass = Class.forName("org.bukkit.potion.PotionData");
                Object potionData = potionDataClass.getConstructor(PotionType.class).newInstance(potionType);
                Method setBasePotionDataMethod = meta.getClass().getMethod("setBasePotionData", potionDataClass);
                setBasePotionDataMethod.invoke((Object)meta, potionData);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        meta.setColor(color);
    }

    public static Sound getSound(@NotNull String key) {
        if (minecraftVersion >= 164) {
            return (Sound)Registry.SOUNDS.get(NamespacedKey.minecraft((String)key));
        }
        try {
            return (Sound)Enum.valueOf(Class.forName("org.bukkit.Sound"), key.replace(".", "_").toUpperCase(Locale.ENGLISH));
        }
        catch (Exception exception) {
            return null;
        }
    }
}

