/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.shaded.dapi.message;

import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dmentions.shaded.dapi.message.ChannelMessage;
import org.nandayo.dmentions.shaded.dapi.model.MiniString;
import org.nandayo.dmentions.shaded.dapi.shaded.kyori.adventure.text.Component;
import org.nandayo.dmentions.shaded.dapi.util.ColorizeType;
import org.nandayo.dmentions.shaded.dapi.util.Util;
import org.nandayo.dmentions.shaded.dapi.util.Validate;

public class ChannelTitleMessage
extends ChannelMessage {
    @NotNull
    private MiniString secondaryMessage = new MiniString("");
    private int fadeInTicks = 10;
    private int stayTicks = 70;
    private int fadeOutTicks = 20;

    protected ChannelTitleMessage(MiniString message, MiniString secondaryMessage, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        super(message);
        Validate.validate(secondaryMessage != null, "Secondary message cannot be null!");
        this.secondaryMessage = secondaryMessage.copy();
        this.fadeInTicks = fadeInTicks;
        this.stayTicks = stayTicks;
        this.fadeOutTicks = fadeOutTicks;
    }

    public ChannelTitleMessage(String message, String secondaryMessage, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        super(message);
        Validate.validate(secondaryMessage != null, "Secondary message cannot be null!");
        this.secondaryMessage = new MiniString(secondaryMessage);
        this.fadeInTicks = fadeInTicks;
        this.stayTicks = stayTicks;
        this.fadeOutTicks = fadeOutTicks;
    }

    @Deprecated(since="1.4.0", forRemoval=true)
    public ChannelTitleMessage(Component message, Component secondaryMessage, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        super("");
        Validate.validate(secondaryMessage != null, "Secondary message cannot be null!");
        this.secondaryMessage = new MiniString("");
        this.fadeInTicks = fadeInTicks;
        this.stayTicks = stayTicks;
        this.fadeOutTicks = fadeOutTicks;
    }

    protected ChannelTitleMessage(MiniString message) {
        super(message);
    }

    protected ChannelTitleMessage(MiniString message, MiniString secondaryMessage) {
        super(message);
        Validate.validate(secondaryMessage != null, "Secondary message cannot be null!");
        this.secondaryMessage = secondaryMessage.copy();
    }

    public ChannelTitleMessage(String message) {
        super(message);
    }

    @Deprecated(since="1.4.0", forRemoval=true)
    public ChannelTitleMessage(Component message) {
        super("");
    }

    public ChannelTitleMessage(String message, String secondaryMessage) {
        super(message);
        Validate.validate(secondaryMessage != null, "Secondary message cannot be null!");
        this.secondaryMessage = new MiniString(secondaryMessage);
    }

    @Deprecated(since="1.4.0", forRemoval=true)
    public ChannelTitleMessage(Component message, Component secondaryMessage) {
        super("");
        Validate.validate(secondaryMessage != null, "Secondary message cannot be null!");
        this.secondaryMessage = new MiniString("");
    }

    public ChannelTitleMessage(String message, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        super(message);
        this.fadeInTicks = fadeInTicks;
        this.stayTicks = stayTicks;
        this.fadeOutTicks = fadeOutTicks;
    }

    @Deprecated(since="1.4.0", forRemoval=true)
    public ChannelTitleMessage(Component message, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        super("");
        this.fadeInTicks = fadeInTicks;
        this.stayTicks = stayTicks;
        this.fadeOutTicks = fadeOutTicks;
    }

    public static ChannelTitleMessage fromParent(ChannelMessage message, boolean isTitle) {
        if (isTitle) {
            return new ChannelTitleMessage(message.message);
        }
        return new ChannelTitleMessage(new MiniString(""), message.message);
    }

    @Override
    public ChannelTitleMessage copy() {
        return new ChannelTitleMessage(this.message, this.secondaryMessage, this.fadeInTicks, this.stayTicks, this.fadeOutTicks);
    }

    public String getRawSecondaryMessage() {
        return this.secondaryMessage.getRawText();
    }

    @Deprecated(since="1.4.0", forRemoval=true)
    public Component getSecondaryMessage() {
        return null;
    }

    @Override
    public ChannelTitleMessage insertPrefix() {
        return new ChannelTitleMessage(Util.PREFIX + this.message.getRawText(), Util.PREFIX + this.secondaryMessage.getRawText(), this.fadeInTicks, this.stayTicks, this.fadeOutTicks);
    }

    @Override
    public ChannelTitleMessage colorize(ColorizeType colorizeType) {
        return new ChannelTitleMessage(this.message.colorize(colorizeType), this.secondaryMessage.colorize(colorizeType), this.fadeInTicks, this.stayTicks, this.fadeOutTicks);
    }

    @Override
    public ChannelTitleMessage replace(String key, String value) {
        return new ChannelTitleMessage(this.message.replace(key, value), this.secondaryMessage.replace(key, value), this.fadeInTicks, this.stayTicks, this.fadeOutTicks);
    }

    @Generated
    public int getFadeInTicks() {
        return this.fadeInTicks;
    }

    @Generated
    public int getStayTicks() {
        return this.stayTicks;
    }

    @Generated
    public int getFadeOutTicks() {
        return this.fadeOutTicks;
    }
}

