/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.shaded.dapi.message;

import org.jetbrains.annotations.NotNull;
import org.nandayo.dmentions.shaded.dapi.message.IChannelMessage;
import org.nandayo.dmentions.shaded.dapi.model.MiniString;
import org.nandayo.dmentions.shaded.dapi.shaded.kyori.adventure.text.Component;
import org.nandayo.dmentions.shaded.dapi.util.ColorizeType;
import org.nandayo.dmentions.shaded.dapi.util.Util;
import org.nandayo.dmentions.shaded.dapi.util.Validate;

public class ChannelMessage
implements IChannelMessage {
    @NotNull
    protected final MiniString message;

    protected ChannelMessage(MiniString message) {
        Validate.validate(message != null, "MiniString cannot be null!");
        this.message = message.copy();
    }

    public ChannelMessage(String message) {
        Validate.validate(message != null, "Message cannot be null!");
        this.message = new MiniString(message);
    }

    @Deprecated(since="1.4.0", forRemoval=true)
    public ChannelMessage(Component message) {
        Validate.validate(message != null, "Message cannot be null!");
        this.message = new MiniString("");
    }

    @Override
    public ChannelMessage copy() {
        return new ChannelMessage(this.message);
    }

    @Override
    public String getRawMessage() {
        return this.message.getRawText();
    }

    @Override
    @Deprecated(since="1.4.0", forRemoval=true)
    public Component getMessage() {
        return null;
    }

    @Override
    public ChannelMessage insertPrefix() {
        return new ChannelMessage(Util.PREFIX + this.message.getRawText());
    }

    @Override
    public ChannelMessage colorize(ColorizeType colorizeType) {
        return new ChannelMessage(this.message.colorize(colorizeType));
    }

    @Override
    public ChannelMessage replace(String key, String value) {
        return new ChannelMessage(this.message.replace(key, value));
    }
}

