/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.shaded.dapi.guimanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dmentions.shaded.dapi.guimanager.CustomSection;
import org.nandayo.dmentions.shaded.dapi.guimanager.MenuItem;
import org.nandayo.dmentions.shaded.dapi.util.Util;

@ApiStatus.Experimental
public class MenuModel {
    @NotNull
    private final String id;
    @NotNull
    private final String title;
    private final int rows;
    @Nullable
    private final Material empty;
    @NotNull
    private final @NotNull Map<Integer, @NotNull MenuItem> items;
    @NotNull
    private final List<CustomSection> customSections;

    public MenuModel(@NotNull String id, @NotNull String title, int rows, @Nullable Material empty, @NotNull Map<Integer, MenuItem> items, @NotNull List<CustomSection> customSections) {
        this.id = id;
        this.title = title;
        this.rows = rows;
        this.empty = empty;
        this.items = new HashMap<Integer, MenuItem>(items);
        this.customSections = new ArrayList<CustomSection>(customSections);
    }

    @NotNull
    public static <T extends ConfigurationSection> MenuModel read(@NotNull T section, boolean readItems) {
        String id = section.getString("id", Util.generateRandomLowerCaseString(4));
        String title = section.getString("title", "Default Title");
        int rows = Math.min(6, Math.max(1, section.getInt("rows")));
        Material empty = Material.getMaterial((String)section.getString("empty", ""));
        ConfigurationSection itemsSection = section.getConfigurationSection("items");
        HashMap<Integer, MenuItem> items = new HashMap<Integer, MenuItem>();
        if (readItems && itemsSection != null) {
            for (String slotStr : itemsSection.getKeys(false)) {
                int slot;
                try {
                    slot = Integer.parseInt(slotStr);
                }
                catch (NumberFormatException e) {
                    slot = 0;
                }
                ConfigurationSection menuItemSection = itemsSection.getConfigurationSection(slotStr);
                if (menuItemSection == null) continue;
                MenuItem menuItem = MenuItem.read(menuItemSection);
                items.put(slot, menuItem);
            }
        }
        ArrayList<CustomSection> customSections = new ArrayList<CustomSection>();
        return new MenuModel(id, title, rows, empty, items, customSections);
    }

    @NotNull
    public static <T extends ConfigurationSection> MenuModel read(@NotNull T section) {
        return MenuModel.read(section, true);
    }

    @NotNull
    @Generated
    public String getId() {
        return this.id;
    }

    @NotNull
    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public int getRows() {
        return this.rows;
    }

    @Nullable
    @Generated
    public Material getEmpty() {
        return this.empty;
    }

    @NotNull
    @Generated
    public @NotNull Map<Integer, @NotNull MenuItem> getItems() {
        return this.items;
    }

    @NotNull
    @Generated
    public List<CustomSection> getCustomSections() {
        return this.customSections;
    }
}

