/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.shaded.dapi.adventure;

import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dmentions.shaded.dapi.adventure.ConstantInfo;
import org.nandayo.dmentions.shaded.dapi.adventure.Depends;
import org.nandayo.dmentions.shaded.dapi.adventure.KeyChange;
import org.nandayo.dmentions.shaded.dapi.adventure.KeyRemoval;
import org.nandayo.dmentions.shaded.dapi.adventure.Node;

class ConstantInfoImpl<T, R>
implements ConstantInfo {
    @NotNull
    private String sinceVersion = "4.0.0";
    @NotNull
    private String key = "---";
    @Nullable
    private ConstantInfo parent = null;
    @Nullable
    private KeyChange keyChange = null;
    @Nullable
    private KeyRemoval keyRemoval = null;
    @Nullable
    private Depends depends = null;
    @Nullable
    private Function<T, R> valueFunction = null;

    @Override
    @NotNull
    public String sinceVersion() {
        return this.sinceVersion;
    }

    @Override
    @NotNull
    public String key() {
        return this.key;
    }

    @Override
    @Nullable
    public ConstantInfo parent() {
        return this.parent;
    }

    @Override
    @Nullable
    public KeyChange keyChange() {
        return this.keyChange;
    }

    @Override
    @Nullable
    public KeyRemoval keyRemoval() {
        return this.keyRemoval;
    }

    @Override
    @Nullable
    public Depends depends() {
        return this.depends;
    }

    @Override
    @Nullable
    public Function<T, R> valueFunction() {
        return this.valueFunction;
    }

    @Override
    public boolean matches(Node node) {
        String nodeParentKey = node.getParent() == null ? null : node.getParent().getKey();
        ConstantInfo parent = this.parent();
        if (parent != null && this.keyRemoval != null && this.keyRemoval.moveIn() && this.keyRemoval.childrenToMove().contains(this)) {
            parent = parent.parent();
        }
        return this.key.equals(node.getKey()) && (parent == null && nodeParentKey == null || parent != null && Objects.equals(parent.key(), nodeParentKey));
    }

    public String toString() {
        if (this.keyRemoval != null) {
            return String.format("Constant[ parent %s, deprecatedKey: %s ]", this.parent == null ? "null" : this.parent.key(), this.keyRemoval.deprecatedKey());
        }
        return String.format("Constant[ parent: %s, key: %s ]", this.parent == null ? "null" : this.parent.key(), this.key);
    }

    @NotNull
    @Generated
    public String getSinceVersion() {
        return this.sinceVersion;
    }

    @NotNull
    @Generated
    public String getKey() {
        return this.key;
    }

    @Nullable
    @Generated
    public ConstantInfo getParent() {
        return this.parent;
    }

    @Nullable
    @Generated
    public KeyChange getKeyChange() {
        return this.keyChange;
    }

    @Nullable
    @Generated
    public KeyRemoval getKeyRemoval() {
        return this.keyRemoval;
    }

    @Nullable
    @Generated
    public Depends getDepends() {
        return this.depends;
    }

    @Nullable
    @Generated
    public Function<T, R> getValueFunction() {
        return this.valueFunction;
    }

    @Generated
    public void setSinceVersion(@NotNull String sinceVersion) {
        if (sinceVersion == null) {
            throw new NullPointerException("sinceVersion is marked non-null but is null");
        }
        this.sinceVersion = sinceVersion;
    }

    @Generated
    public void setKey(@NotNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.key = key;
    }

    @Generated
    public void setParent(@Nullable ConstantInfo parent) {
        this.parent = parent;
    }

    @Generated
    public void setKeyChange(@Nullable KeyChange keyChange) {
        this.keyChange = keyChange;
    }

    @Generated
    public void setKeyRemoval(@Nullable KeyRemoval keyRemoval) {
        this.keyRemoval = keyRemoval;
    }

    @Generated
    public void setDepends(@Nullable Depends depends) {
        this.depends = depends;
    }

    @Generated
    public void setValueFunction(@Nullable Function<T, R> valueFunction) {
        this.valueFunction = valueFunction;
    }

    static class Builder<T, R> {
        private final ConstantInfoImpl<T, R> constantInfo = new ConstantInfoImpl();

        @NotNull
        public ConstantInfoImpl<T, R> build() {
            return this.constantInfo;
        }

        public Builder<T, R> sinceVersion(String sinceVersion) {
            this.constantInfo.setSinceVersion(sinceVersion);
            return this;
        }

        public Builder<T, R> parent(ConstantInfo parent) {
            this.constantInfo.setParent(parent);
            return this;
        }

        public Builder<T, R> keyChange(final String deprecatedKey, final String newKey) {
            this.constantInfo.setKeyChange(new KeyChange(){

                @Override
                @NotNull
                public String deprecatedKey() {
                    return deprecatedKey;
                }

                @Override
                @NotNull
                public String newKey() {
                    return newKey;
                }
            });
            return this;
        }

        public Builder<T, R> key(String key) {
            this.constantInfo.setKey(key);
            return this;
        }

        public Builder<T, R> keyRemoval(final String deprecatedKey, final boolean moveIn, final Set<ConstantInfo> childrenToMove) {
            this.constantInfo.setKeyRemoval(new KeyRemoval(){

                @Override
                @NotNull
                public String deprecatedKey() {
                    return deprecatedKey;
                }

                @Override
                public boolean moveIn() {
                    return moveIn;
                }

                @Override
                @NotNull
                public Set<ConstantInfo> childrenToMove() {
                    return childrenToMove;
                }
            });
            return this;
        }

        public Builder<T, R> depends(Depends depends) {
            this.constantInfo.setDepends(depends);
            return this;
        }

        public Builder<T, R> valueFunction(Function<T, R> valueFunction) {
            this.constantInfo.setValueFunction(valueFunction);
            return this;
        }
    }
}

