/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.service.registry;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.shaded.dapi.service.YAMLRegistry;
import org.nandayo.dmentions.shaded.dapi.util.Util;
import org.nandayo.dmentions.util.DUtil;

public class GUIRegistry
extends YAMLRegistry {
    private static final SimpleDateFormat backupDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    @NotNull
    private FileConfiguration config = this.getConfiguration();
    private boolean loaded;

    public GUIRegistry(@NotNull DMentions plugin) {
        super(plugin);
    }

    @Override
    @NotNull
    protected String filePath() {
        return "gui.yml";
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    @Override
    public void onLoad() {
        this.setLoaded(true);
    }

    @Override
    public void onUnload() {
        this.setLoaded(false);
    }

    public GUIRegistry updateConfiguration() {
        String configVersion;
        String version = this.getPlugin().getDescription().getVersion();
        if (version.equals(configVersion = this.config.getString("gui_version", "0"))) {
            return this;
        }
        FileConfiguration defConfig = this.getSourceConfiguration();
        if (defConfig == null) {
            return this;
        }
        this.saveBackupConfig(this.config);
        for (String key : defConfig.getKeys(true)) {
            if (defConfig.isConfigurationSection(key) || !this.config.contains(key)) continue;
            defConfig.set(key, this.config.get(key));
        }
        defConfig.set("gui_version", (Object)this.getPlugin().getDescription().getVersion());
        this.config = defConfig;
        try {
            this.config.save(this.getFile());
            Util.log("&aUpdated gui file.");
        }
        catch (Exception e) {
            Util.log("&cFailed to save updated gui file. " + e.getMessage());
        }
        return this;
    }

    private int parseVersion(@NotNull String version) {
        String[] parts = version.split("\\.");
        int major = DUtil.parseInt(parts[0], 0);
        int minor = parts.length > 1 ? DUtil.parseInt(parts[1], 0) : 0;
        int patch = parts.length > 2 ? DUtil.parseInt(parts[2], 0) : 0;
        return major * 10000 + minor * 100 + patch;
    }

    private FileConfiguration getSourceConfiguration() {
        InputStream defStream = this.getPlugin().getResource(this.filePath());
        if (defStream == null) {
            Util.log("&cDefault '" + this.filePath() + "' was not found in plugin resources.");
            return null;
        }
        return YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defStream));
    }

    private void saveBackupConfig(@NotNull FileConfiguration config) {
        File backupDir = new File(this.getPlugin().getDataFolder(), "backups");
        if (!backupDir.exists()) {
            backupDir.mkdirs();
        }
        String date = backupDateFormat.format(new Date());
        File backupFile = new File(backupDir, "gui_" + date + ".yml");
        try {
            config.save(backupFile);
            Util.log("&aBacked up old gui file.");
        }
        catch (Exception e) {
            Util.log("&cFailed to save old gui backup file. ");
            e.printStackTrace();
        }
    }

    @Nullable
    public ConfigurationSection getSection(@NotNull String path) {
        return this.config.getConfigurationSection(path);
    }

    @NotNull
    public String getString(@NotNull String path) {
        String str = this.config.getString(path);
        if (str == null) {
            Util.log("&cNull message at path '" + path + "'");
            return "";
        }
        return str;
    }

    @NotNull
    public String getString(@Nullable ConfigurationSection section, @NotNull String path) {
        String currentPath = section == null || section.getCurrentPath() == null ? "" : section.getCurrentPath();
        return this.getString(currentPath + "." + path);
    }

    @NotNull
    public List<String> getStringList(@NotNull String path) {
        return this.config.getStringList(path);
    }

    @NotNull
    public List<String> getStringList(@Nullable ConfigurationSection section, @NotNull String path) {
        String currentPath = section == null || section.getCurrentPath() == null ? "" : section.getCurrentPath();
        return this.getStringList(currentPath + "." + path);
    }
}

