/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.service.message;

import java.util.Locale;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dmentions.shaded.dapi.message.ChannelMessage;
import org.nandayo.dmentions.shaded.dapi.message.ChannelTitleMessage;
import org.nandayo.dmentions.shaded.dapi.message.ChannelType;
import org.nandayo.dmentions.util.DUtil;

public class MessageRouter {
    public static void sendResolved(@NotNull CommandSender receiver, @NotNull String unresolvedMessage) {
        String prefixedMsg = DUtil.replacePrefixes(unresolvedMessage);
        MessageRouter.send(receiver, MessageRouter.resolveChannelMessage(prefixedMsg), MessageRouter.resolveChannelType(prefixedMsg));
    }

    public static void send(@NotNull CommandSender receiver, @NotNull ChannelMessage channelMessage, @NotNull ChannelType channelType) {
        channelType.send(receiver, channelMessage);
    }

    private static ChannelMessage resolveChannelMessage(@NotNull String unresolvedMessage) {
        String[] parts = unresolvedMessage.split("=", -1);
        if (parts.length < 2) {
            return new ChannelMessage(unresolvedMessage);
        }
        if (parts[0].equalsIgnoreCase("TITLE")) {
            String[] titleParts = parts[1].split("\\|\\|", -1);
            String title = titleParts[0];
            String subtitle = titleParts.length > 1 ? titleParts[1] : "";
            return new ChannelTitleMessage(title, subtitle);
        }
        return new ChannelMessage(parts[1]);
    }

    private static ChannelType resolveChannelType(@NotNull String unresolvedMessage) {
        String[] parts = unresolvedMessage.split("=", -1);
        if (parts.length < 2) {
            return ChannelType.CHAT;
        }
        switch (parts[0].toUpperCase(Locale.ENGLISH)) {
            case "ACTION_BAR": {
                return ChannelType.ACTION_BAR;
            }
            case "TITLE": {
                return ChannelType.TITLE_AND_SUBTITLE;
            }
        }
        return ChannelType.CHAT;
    }
}

