/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.service;

import java.util.Locale;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.shaded.dapi.util.Util;

public class Wrapper {
    private final DMentions plugin;
    private final int version;

    public Wrapper(DMentions plugin) {
        this.plugin = plugin;
        this.version = this.fetchVersion();
    }

    private int fetchVersion() {
        int version = org.nandayo.dmentions.shaded.dapi.util.Wrapper.getMinecraftVersion();
        if (version < 165) {
            Util.log(String.format("&cYou are using an unsupported server version '%s'!", this.toVersion(version)), "&cPlease use v1.16.5 or newer.");
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin));
        }
        return version;
    }

    private String toVersion(int v) {
        return "1." + v / 10 + "." + v % 10;
    }

    @Nullable
    public Sound getSound(@NotNull String soundName) {
        NamespacedKey namespacedKey = NamespacedKey.fromString((String)soundName.toLowerCase(Locale.ENGLISH));
        return namespacedKey == null ? null : (Sound)Registry.SOUNDS.get(namespacedKey);
    }

    public void playSound(@NotNull Player player, @NotNull Sound sound, float volume, float pitch) {
        if (this.version >= 181) {
            player.playSound((Entity)player, sound, volume, pitch);
        } else {
            player.playSound(player.getLocation(), sound, volume, pitch);
        }
    }

    public void playSound(@NotNull Player player, @NotNull Sound sound) {
        this.playSound(player, sound, 0.6f, 1.0f);
    }

    @Generated
    public DMentions getPlugin() {
        return this.plugin;
    }

    @Generated
    public int getVersion() {
        return this.version;
    }
}

