/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.service;

import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.nandayo.dmentions.DMentions;

public class UserManager {
    private final String ns = "players.";
    private final File file;
    private final FileConfiguration config;
    private final DMentions plugin;

    public UserManager(DMentions plugin) {
        this.plugin = plugin;
        this.file = new File(this.plugin.getDataFolder(), "players.yml");
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void saveChanges() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Could not save players.yml. " + e.getMessage());
        }
    }

    public boolean getMentionMode(Player player) {
        return this.config.getBoolean("players." + String.valueOf(player.getUniqueId()) + ".mentions", true);
    }

    public void setMentionMode(Player player, boolean mode) {
        this.config.set("players." + String.valueOf(player.getUniqueId()) + ".mentions", (Object)mode);
    }

    public String getMentionDisplay(Player player) {
        return this.config.getString("players." + String.valueOf(player.getUniqueId()) + ".mention_display", player.getName());
    }

    public void setMentionDisplay(Player player, String display) {
        this.config.set("players." + String.valueOf(player.getUniqueId()) + ".mention_display", (Object)display);
    }
}

