/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.service;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.integration.LuckPermsHook;
import org.nandayo.dmentions.service.Config;

public class PermissionManager {
    private static final Set<String> LOADED_PERMISSIONS = new HashSet<String>();
    @NotNull
    private final DMentions plugin;
    @NotNull
    private final Config config;
    private final LuckPermsHook luckPermsHook;

    public PermissionManager(@NotNull DMentions plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfiguration();
        this.luckPermsHook = plugin.getLuckPermsHook();
    }

    public void setupPermissions() {
        String playerPermission = this.config.getConfig().getString("player.permission", "dmentions.mention.player");
        String everyonePermission = this.config.getConfig().getString("everyone.permission", "dmentions.mention.everyone");
        String nearbyPermission = this.config.getConfig().getString("nearby.permission", "dmentions.mention.nearby");
        Bukkit.getPluginManager().addPermission(new Permission(playerPermission, PermissionDefault.OP));
        Bukkit.getPluginManager().addPermission(new Permission(nearbyPermission, PermissionDefault.OP));
        Bukkit.getPluginManager().addPermission(new Permission(everyonePermission, PermissionDefault.OP));
        LOADED_PERMISSIONS.add(playerPermission);
        LOADED_PERMISSIONS.add(nearbyPermission);
        LOADED_PERMISSIONS.add(everyonePermission);
        if (!this.luckPermsHook.isMaskNull()) {
            Permission adminPermission = Bukkit.getPluginManager().getPermission("dmentions.admin");
            if (adminPermission == null) {
                return;
            }
            HashMap<String, Boolean> children = new HashMap<String, Boolean>();
            children.put(playerPermission, true);
            children.put(everyonePermission, true);
            for (String group : this.luckPermsHook.getGroups()) {
                String groupPermission = this.config.getConfig().getString("group.permission", "dmentions.mention.group.{group}").replace("{group}", group);
                Bukkit.getPluginManager().addPermission(new Permission(groupPermission, PermissionDefault.OP));
                LOADED_PERMISSIONS.add(groupPermission);
                children.put(groupPermission, true);
            }
            adminPermission.getChildren().putAll(children);
            adminPermission.recalculatePermissibles();
        }
    }

    public void clearAfterLoadPermissions() {
        if (LOADED_PERMISSIONS.isEmpty()) {
            return;
        }
        Permission adminPermission = Bukkit.getPluginManager().getPermission("dmentions.admin");
        for (String perm : LOADED_PERMISSIONS) {
            Permission permission = Bukkit.getPluginManager().getPermission(perm);
            if (permission != null) {
                Bukkit.getPluginManager().removePermission(permission);
            }
            if (adminPermission == null || !adminPermission.getChildren().containsKey(perm)) continue;
            adminPermission.getChildren().remove(perm);
            adminPermission.recalculatePermissibles();
        }
        LOADED_PERMISSIONS.clear();
    }

    public Set<String> getLoadedPermissions() {
        return new HashSet<String>(LOADED_PERMISSIONS);
    }
}

