/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.service;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.enumeration.MentionType;
import org.nandayo.dmentions.event.MentionEveryoneEvent;
import org.nandayo.dmentions.event.MentionGroupEvent;
import org.nandayo.dmentions.event.MentionNearbyEvent;
import org.nandayo.dmentions.event.MentionPlayerEvent;
import org.nandayo.dmentions.integration.EssentialsHook;
import org.nandayo.dmentions.integration.LuckPermsHook;
import org.nandayo.dmentions.model.MentionHolder;
import org.nandayo.dmentions.service.Config;
import org.nandayo.dmentions.service.CooldownManager;
import org.nandayo.dmentions.service.message.Message;
import org.nandayo.dmentions.shaded.dapi.util.HexUtil;
import org.nandayo.dmentions.util.DUtil;

public class MentionManager {
    private static final Map<String, MentionHolder> MENTION_HOLDERS = new HashMap<String, MentionHolder>();
    private static String KEYWORDS_PATTERN = "";
    @NotNull
    private final DMentions plugin;
    @NotNull
    private final Config config;

    public MentionManager(@NotNull DMentions plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfiguration();
        this.load();
    }

    public void removePlayer(Player player) {
        if (!MENTION_HOLDERS.containsKey(player.getName())) {
            return;
        }
        MENTION_HOLDERS.remove(player.getName());
        this.updateKeywordsPattern();
    }

    public void addPlayer(Player player) {
        if (MENTION_HOLDERS.containsKey(player.getName())) {
            return;
        }
        String perm = this.config.getConfig().getString("player.permission", "dmentions.mention.player");
        MENTION_HOLDERS.put(player.getName(), new MentionHolder(MentionType.PLAYER, perm, player.getName()));
        this.updateKeywordsPattern();
    }

    public void load() {
        String perm;
        String keyword;
        MENTION_HOLDERS.clear();
        if (this.config.getConfig().getBoolean("player.enabled", false)) {
            Bukkit.getOnlinePlayers().forEach(player -> {
                String keyword = player.getName();
                String perm = this.config.getConfig().getString("player.permission", "dmentions.mention.player");
                MENTION_HOLDERS.put(keyword, new MentionHolder(MentionType.PLAYER, perm, keyword));
            });
        }
        if (this.config.getConfig().getBoolean("nearby.enabled", false)) {
            keyword = this.config.getConfig().getString("nearby.keyword", "@nearby");
            perm = this.config.getConfig().getString("nearby.permission", "dmentions.mention.nearby");
            MENTION_HOLDERS.put(keyword, new MentionHolder(MentionType.NEARBY, perm));
        }
        if (this.config.getConfig().getBoolean("everyone.enabled", false)) {
            keyword = this.config.getConfig().getString("everyone.keyword", "@everyone");
            perm = this.config.getConfig().getString("everyone.permission", "dmentions.mention.everyone");
            MENTION_HOLDERS.put(keyword, new MentionHolder(MentionType.EVERYONE, perm));
        }
        LuckPermsHook luckPermsHook = this.plugin.getLuckPermsHook();
        if (this.config.getConfig().getBoolean("group.enabled", false)) {
            List disabledGroups = this.config.getConfig().getStringList("group.disabled_groups");
            String keywordTemplate = this.config.getConfig().getString("group.keyword", "@{group}");
            luckPermsHook.getGroups().stream().filter(group -> !disabledGroups.contains(group)).forEach(group -> {
                String keyword = keywordTemplate.replace("{group}", (CharSequence)group);
                String perm = this.config.getConfig().getString("group.permission", "dmentions.mention.group.{group}").replace("{group}", (CharSequence)group);
                MENTION_HOLDERS.put(keyword, new MentionHolder(MentionType.GROUP, perm, (String)group));
            });
        }
        this.updateKeywordsPattern();
    }

    private void updateKeywordsPattern() {
        KEYWORDS_PATTERN = MENTION_HOLDERS.keySet().stream().map(Pattern::quote).collect(Collectors.joining("|"));
    }

    public Map<String, MentionHolder> getMentionHolders() {
        return ImmutableMap.copyOf(MENTION_HOLDERS);
    }

    public String getKeywordsPattern() {
        return KEYWORDS_PATTERN;
    }

    public String getMentionedString(@NotNull DMentions plugin, @NotNull Player sender, @NotNull String message) {
        CooldownManager cooldownManager = plugin.getCooldownManager();
        EssentialsHook essHook = plugin.getEssentialsHook();
        Pattern mentionPattern = Pattern.compile(String.format("(?<!\\S)(%s)(?=[\\s\\p{P}]|$)", KEYWORDS_PATTERN));
        Matcher matcher = mentionPattern.matcher(message);
        StringBuilder updatedMessage = new StringBuilder();
        int lastAppendPosition = 0;
        int mentionLimit = this.config.getConfig().getInt("mention_limit", 2);
        int mentionCounter = 0;
        block6: while (matcher.find() && mentionCounter < mentionLimit) {
            String keyword = matcher.group(1);
            MentionHolder mentionHolder = MENTION_HOLDERS.get(keyword);
            if (mentionHolder == null || !sender.hasPermission(mentionHolder.getPermission())) continue;
            long remainedCooldown = cooldownManager.getRemaining(mentionHolder.getType(), mentionHolder.getTarget());
            Object displayText = keyword;
            String suffixColor = this.getSuffixColor(sender);
            switch (mentionHolder.getType()) {
                case PLAYER: {
                    Player target;
                    if (mentionHolder.getTarget() == null || (target = Bukkit.getPlayerExact((String)mentionHolder.getTarget())) == null || !plugin.getUserManager().getMentionMode(target)) continue block6;
                    if (remainedCooldown > 0L) {
                        cooldownManager.cooldownWarn(sender, remainedCooldown);
                        continue block6;
                    }
                    if (DUtil.isRestricted(sender, target)) {
                        Message.MENTION_RESTRICTED_WARN.replaceValue("{target}", target.getName()).sendMessage((CommandSender)sender);
                        continue block6;
                    }
                    if (plugin.getConfiguration().getConfig().getBoolean("ignore_respect", true) && essHook.isIgnored(sender, target)) {
                        Message.IGNORE_WARN.replaceValue("{target}", target.getName()).sendMessage((CommandSender)sender);
                        continue block6;
                    }
                    if (plugin.getConfiguration().getConfig().getBoolean("afk_respect", false) && essHook.isAFK(target)) {
                        Message.AFK_WARN.replaceValue("{target}", target.getName()).sendMessage((CommandSender)sender);
                        continue block6;
                    }
                    displayText = this.getPlayerDisplay(target) + suffixColor;
                    Bukkit.getScheduler().runTask((Plugin)plugin, () -> Bukkit.getPluginManager().callEvent((Event)new MentionPlayerEvent(sender, target)));
                    break;
                }
                case NEARBY: {
                    if (remainedCooldown > 0L) {
                        cooldownManager.cooldownWarn(sender, remainedCooldown);
                        continue block6;
                    }
                    displayText = this.config.getConfig().getString("nearby.display", "@nearby") + suffixColor;
                    Bukkit.getScheduler().runTask((Plugin)plugin, () -> Bukkit.getPluginManager().callEvent((Event)new MentionNearbyEvent(sender, this.getNearbyPlayers(sender))));
                    break;
                }
                case EVERYONE: {
                    if (remainedCooldown > 0L) {
                        cooldownManager.cooldownWarn(sender, remainedCooldown);
                        continue block6;
                    }
                    displayText = this.config.getConfig().getString("everyone.display", "@everyone") + suffixColor;
                    Bukkit.getScheduler().runTask((Plugin)plugin, () -> Bukkit.getPluginManager().callEvent((Event)new MentionEveryoneEvent(sender, Bukkit.getOnlinePlayers().toArray(new Player[0]))));
                    break;
                }
                case GROUP: {
                    ConfigurationSection section;
                    String group = mentionHolder.getTarget();
                    if (group == null || (section = DUtil.getGroupConfigSection(group)) == null) continue block6;
                    if (remainedCooldown > 0L) {
                        cooldownManager.cooldownWarn(sender, remainedCooldown);
                        continue block6;
                    }
                    displayText = section.getString("display", "{group}").replace("{group}", group) + suffixColor;
                    Bukkit.getScheduler().runTask((Plugin)plugin, () -> Bukkit.getPluginManager().callEvent((Event)new MentionGroupEvent(sender, group, plugin.getLuckPermsHook().getOnlinePlayersInGroup(group))));
                }
            }
            ++mentionCounter;
            cooldownManager.updateLastUse(mentionHolder.getType(), mentionHolder.getTarget());
            updatedMessage.append(message, lastAppendPosition, matcher.start());
            lastAppendPosition = matcher.end();
            updatedMessage.append(HexUtil.colorize((String)displayText));
        }
        updatedMessage.append(message.substring(lastAppendPosition));
        return updatedMessage.toString();
    }

    private String getPlayerDisplay(@NotNull Player target) {
        String mentionDisplay = this.plugin.getUserManager().getMentionDisplay(target);
        if (mentionDisplay == null || mentionDisplay.isEmpty() || mentionDisplay.equalsIgnoreCase(target.getName())) {
            return this.config.getConfig().getString("player.display", "{p}").replace("{p}", this.plugin.getUserManager().getMentionDisplay(target));
        }
        return this.config.getConfig().getString("player.customized_display", "{display}").replace("{display}", mentionDisplay);
    }

    private String getSuffixColor(@NotNull Player sender) {
        LuckPermsHook luckPermsHook = this.plugin.getLuckPermsHook();
        if (!luckPermsHook.isMaskNull()) {
            String group = luckPermsHook.getGroup(sender);
            ConfigurationSection section = this.config.getConfig().getConfigurationSection("suffix_color.group");
            if (section != null && section.contains(group)) {
                return section.getString(group, "");
            }
        }
        return this.config.getConfig().getString("suffix_color.group.__OTHER__", "");
    }

    private Player[] getNearbyPlayers(@NotNull Player player) {
        int radius = this.config.getConfig().getInt("nearby.radius", 20);
        if (radius <= 0) {
            return new Player[0];
        }
        HashSet<Player> nearbyPlayers = new HashSet<Player>();
        for (Entity entity : player.getNearbyEntities((double)radius, (double)radius, (double)radius)) {
            if (!(entity instanceof Player)) continue;
            Player nearbyPlayer = (Player)entity;
            nearbyPlayers.add(nearbyPlayer);
        }
        return nearbyPlayers.toArray(new Player[0]);
    }
}

