/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.service;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.shaded.dapi.util.Util;
import org.nandayo.dmentions.util.DUtil;

public class LanguageManager {
    private static final SimpleDateFormat backupDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    @NotNull
    private final DMentions plugin;
    @NotNull
    private final File folder;
    public final List<String> REGISTERED_LANGUAGES = new ArrayList<String>();
    private final List<String> DEFAULT_LANGUAGES = Arrays.asList("en-US", "tr-TR", "zh-CN");
    private final String DEFAULT_LANGUAGE = "en-US";
    private FileConfiguration DEFAULT_LANGUAGE_CONFIG;
    private FileConfiguration SELECTED_LANGUAGE_CONFIG;

    public LanguageManager(@NotNull DMentions plugin, @NotNull String fileName) {
        this.plugin = plugin;
        this.folder = new File(plugin.getDataFolder(), "lang");
        if (!this.folder.exists()) {
            this.folder.mkdirs();
        }
        this.loadDefaultFiles();
        this.loadFiles(fileName);
    }

    private void loadFiles(@NotNull String searchingFor) {
        File[] files = this.folder.listFiles((dir, name) -> name.toLowerCase().endsWith(".yml"));
        if (files != null) {
            for (File file : files) {
                String fileName = file.getName().substring(0, file.getName().length() - 4);
                this.REGISTERED_LANGUAGES.add(fileName);
                if (fileName.equals(searchingFor)) {
                    Object object = this.SELECTED_LANGUAGE_CONFIG = this.DEFAULT_LANGUAGES.contains(fileName) ? this.updateLanguage(fileName) : YamlConfiguration.loadConfiguration((File)file);
                }
                if (!fileName.equals("en-US")) continue;
                this.DEFAULT_LANGUAGE_CONFIG = this.updateLanguage(fileName);
            }
        }
        if (this.SELECTED_LANGUAGE_CONFIG == null) {
            this.SELECTED_LANGUAGE_CONFIG = this.DEFAULT_LANGUAGE_CONFIG;
            Util.log("&cLanguage " + searchingFor + " was not found. Using default language.");
        }
    }

    private void loadDefaultFiles() {
        for (String fileName : this.DEFAULT_LANGUAGES) {
            File file = new File(this.folder, fileName + ".yml");
            if (file.exists() || this.plugin.getResource("lang/" + fileName + ".yml") == null) continue;
            this.plugin.saveResource("lang/" + fileName + ".yml", false);
        }
    }

    public FileConfiguration updateLanguage(@NotNull String languageName) {
        String configVersion;
        File file = new File(this.folder, languageName + ".yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        String version = this.plugin.getDescription().getVersion();
        if (version.equals(configVersion = config.getString("lang_version", "0"))) {
            return config;
        }
        FileConfiguration defConfig = this.getSourceConfiguration(languageName);
        if (defConfig == null) {
            return config;
        }
        this.saveBackupConfig(languageName, (FileConfiguration)config);
        for (String key : defConfig.getKeys(true)) {
            if (defConfig.isConfigurationSection(key) || !config.contains(key)) continue;
            defConfig.set(key, config.get(key));
        }
        int oldVersion = this.parseVersion(configVersion);
        if (oldVersion != 0 && oldVersion < 10803 && this.parseVersion(version) >= 10803) {
            ADAPTER_1_8_3.update((FileConfiguration)config, defConfig);
        }
        defConfig.set("lang_version", (Object)this.plugin.getDescription().getVersion());
        config = defConfig;
        try {
            config.save(new File(this.folder, languageName + ".yml"));
            Util.log("&aUpdated language file.");
        }
        catch (Exception e) {
            Util.log("&cFailed to save updated language file. " + e.getMessage());
        }
        return config;
    }

    private boolean compareVersions(@NotNull FileConfiguration config) {
        String version = this.plugin.getDescription().getVersion();
        String configVersion = config.getString("lang_version", "0");
        return version.equals(configVersion);
    }

    private int parseVersion(@NotNull String version) {
        String[] parts = version.split("\\.");
        int major = DUtil.parseInt(parts[0], 0);
        int minor = parts.length > 1 ? DUtil.parseInt(parts[1], 0) : 0;
        int patch = parts.length > 2 ? DUtil.parseInt(parts[2], 0) : 0;
        return major * 10000 + minor * 100 + patch;
    }

    private FileConfiguration getSourceConfiguration(@NotNull String languageName) {
        InputStream defStream = this.plugin.getResource("lang/" + languageName + ".yml");
        if (defStream == null) {
            Util.log("&cDefault '" + languageName + ".yml' was not found in plugin resources.");
            return null;
        }
        return YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defStream));
    }

    private void saveBackupConfig(@NotNull String languageName, @NotNull FileConfiguration config) {
        File backupDir = new File(this.plugin.getDataFolder(), "backups");
        if (!backupDir.exists()) {
            backupDir.mkdirs();
        }
        String date = backupDateFormat.format(new Date());
        File backupFile = new File(backupDir, "lang_" + languageName + "_" + date + ".yml");
        try {
            config.save(backupFile);
            Util.log("&aBacked up old language file.");
        }
        catch (Exception e) {
            Util.log("&cFailed to save old language backup file. ");
            e.printStackTrace();
        }
    }

    @Nullable
    public ConfigurationSection getSection(@NotNull String path) {
        ConfigurationSection section = this.SELECTED_LANGUAGE_CONFIG.getConfigurationSection(path);
        if (section != null) {
            return section;
        }
        return this.DEFAULT_LANGUAGE_CONFIG.getConfigurationSection(path);
    }

    @NotNull
    public Object get(@NotNull String path) {
        Object obj;
        Object object = obj = this.SELECTED_LANGUAGE_CONFIG.contains(path) ? this.SELECTED_LANGUAGE_CONFIG.get(path) : this.DEFAULT_LANGUAGE_CONFIG.get(path);
        if (obj == null) {
            Util.log("&cNull object at path '" + path + "'");
            return "";
        }
        return obj;
    }

    @NotNull
    public String getString(@NotNull String path) {
        String str;
        String string = str = this.SELECTED_LANGUAGE_CONFIG.contains(path) ? this.SELECTED_LANGUAGE_CONFIG.getString(path) : this.DEFAULT_LANGUAGE_CONFIG.getString(path);
        if (str == null) {
            Util.log("&cNull message at path '" + path + "'");
            return "";
        }
        return str;
    }

    @NotNull
    public List<String> getStringList(@NotNull String path) {
        return this.SELECTED_LANGUAGE_CONFIG.contains(path) ? this.SELECTED_LANGUAGE_CONFIG.getStringList(path) : this.DEFAULT_LANGUAGE_CONFIG.getStringList(path);
    }

    @NotNull
    public Boolean getBoolean(@NotNull String path) {
        return this.SELECTED_LANGUAGE_CONFIG.contains(path) ? this.SELECTED_LANGUAGE_CONFIG.getBoolean(path) : this.DEFAULT_LANGUAGE_CONFIG.getBoolean(path);
    }

    @NotNull
    public String getString(@Nullable ConfigurationSection section, @NotNull String subPath) {
        String currentPath = section == null ? "" : section.getCurrentPath();
        return this.getString(currentPath + "." + subPath);
    }

    @NotNull
    public List<String> getStringList(@Nullable ConfigurationSection section, @NotNull String subPath) {
        String currentPath = section == null ? "" : section.getCurrentPath();
        return this.getStringList(currentPath + "." + subPath);
    }

    @NotNull
    public Boolean getBoolean(@Nullable ConfigurationSection section, @NotNull String subPath) {
        String currentPath = section == null ? "" : section.getCurrentPath();
        return this.getBoolean(currentPath + "." + subPath);
    }

    private static class ADAPTER_1_8_3 {
        private static final Pattern OLD_HEX_PATTERN = Pattern.compile("<(#[0-9A-Fa-f]{6})>");

        private ADAPTER_1_8_3() {
        }

        private static void update(@NotNull FileConfiguration oldConfig, @NotNull FileConfiguration defConfig) {
            ConfigurationSection groupSection = oldConfig.getConfigurationSection("group");
            ArrayList<String> key1List = new ArrayList<String>(Arrays.asList("player", "nearby", "everyone"));
            if (groupSection != null) {
                for (String string : groupSection.getKeys(false)) {
                    key1List.add("group." + string);
                }
            }
            for (String string : Arrays.asList("sender_message", "target_message")) {
                for (String key1 : key1List) {
                    boolean isSenderMessageAndPlayerSection;
                    defConfig.set(key1 + ".title", null);
                    defConfig.set(key1 + ".action_bar", null);
                    ArrayList<CallSite> value = new ArrayList<CallSite>();
                    boolean bl = isSenderMessageAndPlayerSection = key1.equals("player") && string.equals("sender_message");
                    if (oldConfig.contains(key1 + ".action_bar." + string)) {
                        value.add((CallSite)((Object)("ACTION_BAR=" + oldConfig.getString(key1 + ".action_bar." + string, "").replace("{p}", isSenderMessageAndPlayerSection ? "{target}" : "{sender}"))));
                    }
                    if (oldConfig.contains(key1 + ".title." + string)) {
                        value.add((CallSite)((Object)("TITLE=" + oldConfig.getString(key1 + ".title." + string, "").replace("{p}", isSenderMessageAndPlayerSection ? "{target}" : "{sender}"))));
                    }
                    defConfig.set(key1 + "." + string, value);
                }
            }
            defConfig.set("cooldown_warn", (Object)oldConfig.getString("cooldown_warn", "").replace("{REMAINED}", "{remained}"));
            defConfig.set("command.user.mentions.success", (Object)oldConfig.getString("command.user.mentions.success", "").replace("{p}", "{target}"));
            defConfig.set("command.user.display.success", (Object)oldConfig.getString("command.user.display.success", "").replace("{p}", "{target}"));
            for (Map.Entry entry : defConfig.getValues(true).entrySet()) {
                String key = (String)entry.getKey();
                if (defConfig.isConfigurationSection(key)) continue;
                Object value = entry.getValue();
                if (value instanceof String) {
                    String str = (String)value;
                    defConfig.set(key, (Object)ADAPTER_1_8_3.replaceHexPatterns(str));
                    continue;
                }
                if (!(value instanceof List)) continue;
                List list = (List)value;
                ArrayList<String> updated = new ArrayList<String>();
                for (Object o : list) {
                    if (o instanceof String) {
                        String str = (String)o;
                        updated.add(ADAPTER_1_8_3.replaceHexPatterns(str));
                        continue;
                    }
                    updated.add((String)o);
                }
                defConfig.set(key, updated);
            }
        }

        private static String replaceHexPatterns(String input) {
            if (input == null || input.isEmpty()) {
                return "";
            }
            String output = input;
            Matcher matcher = OLD_HEX_PATTERN.matcher(input);
            while (matcher.find()) {
                String original = matcher.group();
                String hex = matcher.group(1);
                output = output.replace(original, "&" + hex);
            }
            return output;
        }
    }
}

