/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.service;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.service.message.Message;
import org.nandayo.dmentions.shaded.dapi.util.Util;
import org.nandayo.dmentions.util.DUtil;

public class Config {
    private static final SimpleDateFormat backupDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    private FileConfiguration config;
    private FileConfiguration unsavedConfig;
    @NotNull
    private final DMentions plugin;

    public Config(@NotNull DMentions plugin) {
        this.plugin = plugin;
        File file = new File(this.plugin.getDataFolder(), "config.yml");
        if (!file.exists()) {
            this.plugin.saveResource("config.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)file);
        this.resetUnsavedConfig();
    }

    public Config updateConfig() {
        String configVersion;
        String version = this.plugin.getDescription().getVersion();
        if (version.equals(configVersion = this.config.getString("config_version", "0"))) {
            return this;
        }
        FileConfiguration defConfig = this.getSourceConfiguration();
        if (defConfig == null) {
            return this;
        }
        this.saveBackupConfig();
        for (String key : defConfig.getKeys(true)) {
            if (key.startsWith("suffix_color.group") || key.startsWith("disabled_worlds") || key.startsWith("group.disabled_groups") || key.startsWith("group.list") || defConfig.isConfigurationSection(key) || !this.config.contains(key)) continue;
            defConfig.set(key, this.config.get(key));
        }
        this.handleSpecialCases(defConfig);
        int oldVersion = this.parseVersion(configVersion);
        if (oldVersion != 0 && oldVersion < 10803 && this.parseVersion(version) >= 10803) {
            ADAPTER_1_8_3.update(this.config, defConfig);
        }
        defConfig.set("config_version", (Object)this.plugin.getDescription().getVersion());
        this.config = defConfig;
        this.resetUnsavedConfig();
        try {
            this.config.save(new File(this.plugin.getDataFolder(), "config.yml"));
            Util.log("&aUpdated config file.");
        }
        catch (IOException e) {
            Util.log("&cFailed to save updated config file.");
            e.printStackTrace();
        }
        return this;
    }

    private boolean compareVersions() {
        String pluginVersion = this.plugin.getDescription().getVersion();
        String configVersion = this.config.getString("config_version", "0");
        return pluginVersion.equals(configVersion);
    }

    private int parseVersion(@NotNull String version) {
        String[] parts = version.split("\\.");
        int major = DUtil.parseInt(parts[0], 0);
        int minor = parts.length > 1 ? DUtil.parseInt(parts[1], 0) : 0;
        int patch = parts.length > 2 ? DUtil.parseInt(parts[2], 0) : 0;
        return major * 10000 + minor * 100 + patch;
    }

    private FileConfiguration getSourceConfiguration() {
        InputStream defStream = this.plugin.getResource("config.yml");
        if (defStream == null) {
            Util.log("&cDefault config.yml not found in plugin resources.");
            return null;
        }
        return YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defStream));
    }

    private void saveBackupConfig() {
        File backupDir = new File(this.plugin.getDataFolder(), "backups");
        if (!backupDir.exists()) {
            backupDir.mkdirs();
        }
        String date = backupDateFormat.format(new Date());
        File backupFile = new File(backupDir, "config_" + date + ".yml");
        try {
            this.config.save(backupFile);
            Util.log("&aBacked up old config file.");
        }
        catch (Exception e) {
            Util.log("&cFailed to save old config backup file.");
            e.printStackTrace();
        }
    }

    private void handleSpecialCases(@NotNull FileConfiguration defConfig) {
        defConfig.set("suffix_color.group", null);
        ConfigurationSection suffixSection = this.config.getConfigurationSection("suffix_color.group");
        if (suffixSection != null) {
            for (String group : suffixSection.getKeys(true)) {
                defConfig.set(suffixSection.getCurrentPath() + "." + group, (Object)suffixSection.getString(group));
            }
        }
        defConfig.set("disabled_worlds", (Object)this.config.getStringList("disabled_worlds"));
        defConfig.set("group.disabled_groups", (Object)this.config.getStringList("group.disabled_groups"));
        ConfigurationSection groupSection = this.config.getConfigurationSection("group.list");
        ConfigurationSection keySection = defConfig.getConfigurationSection("group.list.default");
        Set keys = keySection != null ? keySection.getKeys(true) : new HashSet();
        defConfig.set("group.list", null);
        if (groupSection != null) {
            for (String group : groupSection.getKeys(false)) {
                for (String key : keys) {
                    if (this.config.isConfigurationSection(group + "." + key)) continue;
                    defConfig.set(groupSection.getCurrentPath() + "." + group + "." + key, groupSection.get(group + "." + key));
                }
            }
        }
    }

    public void resetUnsavedConfig(CommandSender sender) {
        this.unsavedConfig = YamlConfiguration.loadConfiguration((Reader)new StringReader(this.config.saveToString()));
        if (sender != null) {
            Message.COMMAND_CONFIG_RESET_CHANGES.sendMessage(sender);
        }
    }

    public void resetUnsavedConfig() {
        this.resetUnsavedConfig(null);
    }

    public void saveUnsavedConfig(CommandSender sender) {
        this.config = YamlConfiguration.loadConfiguration((Reader)new StringReader(this.unsavedConfig.saveToString()));
        if (sender != null) {
            Message.COMMAND_CONFIG_SAVE_CHANGES.sendMessage(sender);
            Util.log("&eUpdated config keys in-game by player " + sender.getName() + ".");
        }
        try {
            this.config.save(new File(this.plugin.getDataFolder(), "config.yml"));
            this.plugin.updateVariables();
        }
        catch (IOException e) {
            Util.log("&cFailed to save old config file.");
        }
    }

    public void saveUnsavedConfig() {
        this.saveUnsavedConfig(null);
    }

    public boolean isValueChanged(@NotNull String path) {
        return !Objects.equals(this.config.get(path), this.unsavedConfig.get(path));
    }

    public String getValueDisplayMessage(@NotNull String message, @NotNull String configPath) {
        return message.replace("{value}", this.config.getString(configPath, "")).replace("{unsaved_value}", this.unsavedConfig.getString(configPath, ""));
    }

    @Generated
    public FileConfiguration getConfig() {
        return this.config;
    }

    @Generated
    public FileConfiguration getUnsavedConfig() {
        return this.unsavedConfig;
    }

    @NotNull
    @Generated
    public DMentions getPlugin() {
        return this.plugin;
    }

    private static class ADAPTER_1_8_3 {
        private static final Pattern OLD_HEX_PATTERN = Pattern.compile("<(#[0-9A-Fa-f]{6})>");

        private ADAPTER_1_8_3() {
        }

        private static void update(@NotNull FileConfiguration oldConfig, @NotNull FileConfiguration defConfig) {
            for (Map.Entry entry : defConfig.getValues(true).entrySet()) {
                String key = (String)entry.getKey();
                if (defConfig.isConfigurationSection(key)) continue;
                Object value = entry.getValue();
                if (value instanceof String) {
                    String str = (String)value;
                    defConfig.set(key, (Object)ADAPTER_1_8_3.replaceHexPatterns(str));
                    continue;
                }
                if (!(value instanceof List)) continue;
                List list = (List)value;
                ArrayList<String> updated = new ArrayList<String>();
                for (Object o : list) {
                    if (o instanceof String) {
                        String str = (String)o;
                        updated.add(ADAPTER_1_8_3.replaceHexPatterns(str));
                        continue;
                    }
                    updated.add((String)o);
                }
                defConfig.set(key, updated);
            }
        }

        private static String replaceHexPatterns(String input) {
            if (input == null || input.isEmpty()) {
                return "";
            }
            String output = input;
            Matcher matcher = OLD_HEX_PATTERN.matcher(input);
            while (matcher.find()) {
                String original = matcher.group();
                String hex = matcher.group(1);
                output = output.replace(original, "&" + hex);
            }
            return output;
        }
    }
}

