/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.model;

import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dmentions.util.DUtil;

public class SoundProperty {
    @NotNull
    private final String key;
    private final float volume;
    private final float pitch;

    public SoundProperty(@NotNull String key, float volume, float pitch) {
        this.key = key;
        this.volume = Math.max(0.0f, volume);
        this.pitch = Math.max(0.0f, pitch);
    }

    @NotNull
    public static SoundProperty deserialize(@NotNull String str) {
        String[] split = str.split(";", 3);
        float volume = split.length > 1 ? DUtil.parseFloat(split[1], 0.6f) : 0.6f;
        float pitch = split.length > 2 ? DUtil.parseFloat(split[2], 1.0f) : 1.0f;
        return new SoundProperty(split[0], volume, pitch);
    }

    @NotNull
    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public float getVolume() {
        return this.volume;
    }

    @Generated
    public float getPitch() {
        return this.pitch;
    }
}

